"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformAttackDiscoveryScheduleUpdatePropsFromApi = void 0;
var _transform_attack_discovery_schedule_actions_props_from_api = require("../transform_attack_discovery_schedule_actions_props_from_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformAttackDiscoveryScheduleUpdatePropsFromApi = apiUpdateProps => {
  var _transformAttackDisco;
  return {
    name: apiUpdateProps.name,
    params: {
      alertsIndexPattern: apiUpdateProps.params.alerts_index_pattern,
      apiConfig: apiUpdateProps.params.api_config,
      end: apiUpdateProps.params.end,
      query: apiUpdateProps.params.query,
      filters: apiUpdateProps.params.filters,
      combinedFilter: apiUpdateProps.params.combined_filter,
      size: apiUpdateProps.params.size,
      start: apiUpdateProps.params.start
    },
    schedule: apiUpdateProps.schedule,
    actions: (_transformAttackDisco = (0, _transform_attack_discovery_schedule_actions_props_from_api.transformAttackDiscoveryScheduleActionsPropsFromApi)(apiUpdateProps.actions)) !== null && _transformAttackDisco !== void 0 ? _transformAttackDisco : []
  };
};
exports.transformAttackDiscoveryScheduleUpdatePropsFromApi = transformAttackDiscoveryScheduleUpdatePropsFromApi;