"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addControlsFromSavedSession = void 0;
var _esqlTypes = require("@kbn/esql-types");
var _controlsConstants = require("@kbn/controls-constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const addControlsFromSavedSession = (container, savedObject) => {
  const savedSessionAttributes = savedObject.attributes;
  if (!savedSessionAttributes.controlGroupJson || Object.keys(savedSessionAttributes.controlGroupJson).length === 0) {
    return;
  }
  const controlsState = JSON.parse(savedSessionAttributes.controlGroupJson);
  if (!(0, _esqlTypes.apiPublishesESQLVariables)(container) || !('controlGroupApi$' in container)) {
    return;
  }
  const esqlVariables$ = container.esqlVariables$;
  const esqlVariables = esqlVariables$ === null || esqlVariables$ === void 0 ? void 0 : esqlVariables$.getValue();
  const controlGroupApi$ = container.controlGroupApi$;
  const controlGroupApi = controlGroupApi$.getValue();

  // Only add controls whose variableName exists in current esqlVariables
  Object.values(controlsState).forEach(panel => {
    const variableName = panel.variableName;
    const variableExists = esqlVariables === null || esqlVariables === void 0 ? void 0 : esqlVariables.some(esqlVar => esqlVar.key === variableName);
    if (!variableExists) {
      controlGroupApi.addNewPanel({
        panelType: _controlsConstants.ESQL_CONTROL,
        serializedState: {
          rawState: {
            ...panel
          }
        }
      });
    }
  });
};
exports.addControlsFromSavedSession = addControlsFromSavedSession;