"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isLogsDataSourceContext = exports.createLogsDataSourceProfileProvider = void 0;
var _rxjs = require("rxjs");
var _profiles = require("../../../profiles");
var _accessors = require("./accessors");
var _extract_index_pattern_from = require("../../extract_index_pattern_from");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LOGS_DATA_SOURCE_PROFILE_ID = 'observability-logs-data-source-profile';
const isLogsDataSourceContext = dataSourceContext => dataSourceContext.category === _profiles.DataSourceCategory.Logs && 'logOverviewContext$' in dataSourceContext && dataSourceContext.logOverviewContext$ instanceof _rxjs.BehaviorSubject;
exports.isLogsDataSourceContext = isLogsDataSourceContext;
const createLogsDataSourceProfileProvider = services => ({
  profileId: LOGS_DATA_SOURCE_PROFILE_ID,
  profile: {
    getDefaultAppState: (0, _accessors.createGetDefaultAppState)(),
    getCellRenderers: _accessors.getCellRenderers,
    getRowIndicatorProvider: _accessors.getRowIndicatorProvider,
    getRowAdditionalLeadingControls: _accessors.getRowAdditionalLeadingControls,
    getPaginationConfig: _accessors.getPaginationConfig,
    getColumnsConfiguration: _accessors.getColumnsConfiguration,
    getRecommendedFields: (0, _accessors.createRecommendedFields)({})
  },
  resolve: params => {
    if (params.rootContext.solutionType !== _profiles.SolutionType.Observability) {
      return {
        isMatch: false
      };
    }
    const indexPattern = (0, _extract_index_pattern_from.extractIndexPatternFrom)(params);
    if (!services.logsContextService.isLogsIndexPattern(indexPattern)) {
      return {
        isMatch: false
      };
    }
    return {
      isMatch: true,
      context: {
        category: _profiles.DataSourceCategory.Logs,
        logOverviewContext$: new _rxjs.BehaviorSubject(undefined)
      }
    };
  }
});
exports.createLogsDataSourceProfileProvider = createLogsDataSourceProfileProvider;