"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChartSection = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _unifiedMetricsGrid = require("@kbn/unified-metrics-grid");
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/context_awareness/profile_providers/metrics_data_source_profile/accessor/chart_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const createChartSection = metricsExperienceClient =>
// prevents unmounting the component when the query changes but the index pattern is still valid
(0, _lodash.once)(prev => (0, _lodash.once)(() => {
  return {
    ...(prev ? prev() : {}),
    Component: props => {
      // This will prevent the filter being added to the query for multi-dimensional breakdowns when the user clicks on a data point on the series.
      const handleFilter = event => {
        if (props.onFilter) {
          props.onFilter(event);
        }
        event.preventDefault();
      };
      return /*#__PURE__*/_react.default.createElement(_unifiedMetricsGrid.UnifiedMetricsExperienceGrid, (0, _extends2.default)({}, props, {
        onFilter: handleFilter,
        client: metricsExperienceClient,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 13
        }
      }));
    },
    replaceDefaultChart: !!metricsExperienceClient,
    localStorageKeyPrefix: 'discover:metricsExperience',
    defaultTopPanelHeight: 'max-content'
  };
}));
exports.createChartSection = createChartSection;