"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregateRequestAdapter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/inspector-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * A request adapter that aggregates multiple separate adapters into one to allow inspection
 */
class AggregateRequestAdapter extends _public.RequestAdapter {
  constructor(adapters) {
    super();
    (0, _defineProperty2.default)(this, "adapters", void 0);
    this.adapters = adapters;
  }
  reset(...args) {
    super.reset(...args);
    this.adapters.forEach(adapter => adapter.reset(...args));
  }
  resetRequest(...args) {
    super.resetRequest(...args);
    this.adapters.forEach(adapter => adapter.resetRequest(...args));
  }
  getRequests(...args) {
    return [...super.getRequests(), ...this.adapters.map(adapter => adapter.getRequests(...args)).flat()];
  }
  addListener(...args) {
    super.addListener(...args);
    this.adapters.forEach(adapter => adapter.addListener(...args));
    return this;
  }
  on(...args) {
    super.on(...args);
    this.adapters.forEach(adapter => adapter.on(...args));
    return this;
  }
  once(...args) {
    super.once(...args);
    this.adapters.forEach(adapter => adapter.once(...args));
    return this;
  }
  removeListener(...args) {
    super.removeListener(...args);
    this.adapters.forEach(adapter => adapter.removeListener(...args));
    return this;
  }
  off(...args) {
    super.off(...args);
    this.adapters.forEach(adapter => adapter.off(...args));
    return this;
  }
  removeAllListeners(...args) {
    super.removeAllListeners(...args);
    this.adapters.forEach(adapter => adapter.removeAllListeners(...args));
    return this;
  }
  setMaxListeners(...args) {
    super.setMaxListeners(...args);
    this.adapters.forEach(adapter => adapter.setMaxListeners(...args));
    return this;
  }
  getMaxListeners(...args) {
    return Math.min(super.getMaxListeners(...args), ...this.adapters.map(adapter => adapter.getMaxListeners(...args)));
  }
  listeners(...args) {
    return [...super.listeners(...args), ...this.adapters.map(adapter => adapter.listeners(...args)).flat()];
  }
  rawListeners(...args) {
    return [...super.rawListeners(...args), ...this.adapters.map(adapter => adapter.rawListeners(...args)).flat()];
  }
  emit(...args) {
    return [super.emit(...args), ...this.adapters.map(adapter => adapter.emit(...args))].every(result => result);
  }
  listenerCount(...args) {
    return this.adapters.map(adapter => adapter.listenerCount(...args)).reduce((a, b) => a + b, super.listenerCount(...args));
  }
  prependListener(...args) {
    super.prependListener(...args);
    this.adapters.forEach(adapter => adapter.prependListener(...args));
    return this;
  }
  prependOnceListener(...args) {
    super.prependOnceListener(...args);
    this.adapters.forEach(adapter => adapter.prependOnceListener(...args));
    return this;
  }
  eventNames(...args) {
    return [...super.eventNames(...args), ...this.adapters.map(adapter => adapter.eventNames(...args)).flat()];
  }
}
exports.AggregateRequestAdapter = AggregateRequestAdapter;