"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromTabStateToSavedObjectTab = exports.fromSavedSearchToSavedObjectTab = exports.fromSavedObjectTabToTabState = exports.fromSavedObjectTabToSavedSearch = void 0;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
var _data_sources = require("../../../../../common/data_sources");
var _get_allowed_sample_size = require("../../../../utils/get_allowed_sample_size");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fromSavedObjectTabToTabState = ({
  tab,
  existingTab
}) => ({
  ..._constants.DEFAULT_TAB_STATE,
  ...existingTab,
  id: tab.id,
  label: tab.label,
  initialInternalState: {
    serializedSearchSource: tab.serializedSearchSource,
    visContext: tab.visContext,
    controlGroupJson: tab.controlGroupJson
  },
  initialAppState: {
    columns: tab.columns,
    filters: tab.serializedSearchSource.filter,
    grid: tab.grid,
    hideChart: tab.hideChart,
    dataSource: (0, _data_sources.createDataSource)({
      query: tab.serializedSearchSource.query,
      dataView: tab.serializedSearchSource.index
    }),
    query: tab.serializedSearchSource.query,
    sort: tab.sort,
    viewMode: tab.viewMode,
    hideAggregatedPreview: tab.hideAggregatedPreview,
    rowHeight: tab.rowHeight,
    headerRowHeight: tab.headerRowHeight,
    rowsPerPage: tab.rowsPerPage,
    sampleSize: tab.sampleSize,
    breakdownField: tab.breakdownField,
    density: tab.density
  },
  globalState: {
    timeRange: tab.timeRestore ? tab.timeRange : existingTab === null || existingTab === void 0 ? void 0 : existingTab.globalState.timeRange,
    refreshInterval: tab.timeRange ? tab.refreshInterval : existingTab === null || existingTab === void 0 ? void 0 : existingTab.globalState.refreshInterval
  }
});
exports.fromSavedObjectTabToTabState = fromSavedObjectTabToTabState;
const fromSavedObjectTabToSavedSearch = async ({
  tab,
  discoverSession,
  services
}) => ({
  id: discoverSession.id,
  title: discoverSession.title,
  description: discoverSession.description,
  tags: discoverSession.tags,
  managed: discoverSession.managed,
  references: discoverSession.references,
  sharingSavedObjectProps: discoverSession.sharingSavedObjectProps,
  sort: tab.sort,
  columns: tab.columns,
  grid: tab.grid,
  hideChart: tab.hideChart,
  isTextBasedQuery: tab.isTextBasedQuery,
  usesAdHocDataView: tab.usesAdHocDataView,
  searchSource: await services.data.search.searchSource.create(tab.serializedSearchSource),
  viewMode: tab.viewMode,
  hideAggregatedPreview: tab.hideAggregatedPreview,
  rowHeight: tab.rowHeight,
  headerRowHeight: tab.headerRowHeight,
  timeRestore: tab.timeRestore,
  timeRange: tab.timeRange,
  refreshInterval: tab.refreshInterval,
  rowsPerPage: tab.rowsPerPage,
  sampleSize: tab.sampleSize,
  breakdownField: tab.breakdownField,
  density: tab.density,
  visContext: tab.visContext,
  controlGroupJson: tab.controlGroupJson
});
exports.fromSavedObjectTabToSavedSearch = fromSavedObjectTabToSavedSearch;
const fromTabStateToSavedObjectTab = ({
  tab,
  timeRestore,
  services
}) => {
  var _tab$initialAppState, _tab$initialAppState$, _tab$initialAppState2, _tab$initialAppState$2, _tab$initialAppState3, _tab$initialAppState$3, _tab$initialAppState4, _tab$initialAppState$4, _tab$initialAppState5, _tab$initialAppState6, _tab$initialInternalS, _tab$initialInternalS2, _tab$initialInternalS3, _tab$initialInternalS4, _tab$initialAppState7, _tab$initialAppState8, _tab$initialAppState9, _tab$initialAppState10, _tab$initialAppState11, _tab$initialAppState12, _tab$initialAppState13, _tab$initialAppState14, _tab$initialInternalS5, _tab$initialInternalS6;
  const allowedSampleSize = (0, _get_allowed_sample_size.getAllowedSampleSize)((_tab$initialAppState = tab.initialAppState) === null || _tab$initialAppState === void 0 ? void 0 : _tab$initialAppState.sampleSize, services.uiSettings);
  return {
    id: tab.id,
    label: tab.label,
    sort: (_tab$initialAppState$ = (_tab$initialAppState2 = tab.initialAppState) === null || _tab$initialAppState2 === void 0 ? void 0 : _tab$initialAppState2.sort) !== null && _tab$initialAppState$ !== void 0 ? _tab$initialAppState$ : [],
    columns: (_tab$initialAppState$2 = (_tab$initialAppState3 = tab.initialAppState) === null || _tab$initialAppState3 === void 0 ? void 0 : _tab$initialAppState3.columns) !== null && _tab$initialAppState$2 !== void 0 ? _tab$initialAppState$2 : [],
    grid: (_tab$initialAppState$3 = (_tab$initialAppState4 = tab.initialAppState) === null || _tab$initialAppState4 === void 0 ? void 0 : _tab$initialAppState4.grid) !== null && _tab$initialAppState$3 !== void 0 ? _tab$initialAppState$3 : {},
    hideChart: (_tab$initialAppState$4 = (_tab$initialAppState5 = tab.initialAppState) === null || _tab$initialAppState5 === void 0 ? void 0 : _tab$initialAppState5.hideChart) !== null && _tab$initialAppState$4 !== void 0 ? _tab$initialAppState$4 : false,
    isTextBasedQuery: (0, _esQuery.isOfAggregateQueryType)((_tab$initialAppState6 = tab.initialAppState) === null || _tab$initialAppState6 === void 0 ? void 0 : _tab$initialAppState6.query),
    usesAdHocDataView: (0, _lodash.isObject)((_tab$initialInternalS = tab.initialInternalState) === null || _tab$initialInternalS === void 0 ? void 0 : (_tab$initialInternalS2 = _tab$initialInternalS.serializedSearchSource) === null || _tab$initialInternalS2 === void 0 ? void 0 : _tab$initialInternalS2.index),
    serializedSearchSource: (_tab$initialInternalS3 = (_tab$initialInternalS4 = tab.initialInternalState) === null || _tab$initialInternalS4 === void 0 ? void 0 : _tab$initialInternalS4.serializedSearchSource) !== null && _tab$initialInternalS3 !== void 0 ? _tab$initialInternalS3 : {},
    viewMode: (_tab$initialAppState7 = tab.initialAppState) === null || _tab$initialAppState7 === void 0 ? void 0 : _tab$initialAppState7.viewMode,
    hideAggregatedPreview: (_tab$initialAppState8 = tab.initialAppState) === null || _tab$initialAppState8 === void 0 ? void 0 : _tab$initialAppState8.hideAggregatedPreview,
    rowHeight: (_tab$initialAppState9 = tab.initialAppState) === null || _tab$initialAppState9 === void 0 ? void 0 : _tab$initialAppState9.rowHeight,
    headerRowHeight: (_tab$initialAppState10 = tab.initialAppState) === null || _tab$initialAppState10 === void 0 ? void 0 : _tab$initialAppState10.headerRowHeight,
    timeRestore,
    timeRange: timeRestore ? tab.globalState.timeRange : undefined,
    refreshInterval: timeRestore ? tab.globalState.refreshInterval : undefined,
    rowsPerPage: (_tab$initialAppState11 = tab.initialAppState) === null || _tab$initialAppState11 === void 0 ? void 0 : _tab$initialAppState11.rowsPerPage,
    sampleSize: (_tab$initialAppState12 = tab.initialAppState) !== null && _tab$initialAppState12 !== void 0 && _tab$initialAppState12.sampleSize && tab.initialAppState.sampleSize === allowedSampleSize ? tab.initialAppState.sampleSize : undefined,
    breakdownField: (_tab$initialAppState13 = tab.initialAppState) === null || _tab$initialAppState13 === void 0 ? void 0 : _tab$initialAppState13.breakdownField,
    density: (_tab$initialAppState14 = tab.initialAppState) === null || _tab$initialAppState14 === void 0 ? void 0 : _tab$initialAppState14.density,
    visContext: (_tab$initialInternalS5 = tab.initialInternalState) === null || _tab$initialInternalS5 === void 0 ? void 0 : _tab$initialInternalS5.visContext,
    controlGroupJson: (_tab$initialInternalS6 = tab.initialInternalState) === null || _tab$initialInternalS6 === void 0 ? void 0 : _tab$initialInternalS6.controlGroupJson
  };
};
exports.fromTabStateToSavedObjectTab = fromTabStateToSavedObjectTab;
const fromSavedSearchToSavedObjectTab = ({
  tab,
  savedSearch,
  services
}) => {
  var _savedSearch$sort, _savedSearch$columns, _savedSearch$grid, _savedSearch$hideChar, _savedSearch$isTextBa, _savedSearch$searchSo;
  const allowedSampleSize = (0, _get_allowed_sample_size.getAllowedSampleSize)(savedSearch.sampleSize, services.uiSettings);
  return {
    id: tab.id,
    label: tab.label,
    sort: (_savedSearch$sort = savedSearch.sort) !== null && _savedSearch$sort !== void 0 ? _savedSearch$sort : [],
    columns: (_savedSearch$columns = savedSearch.columns) !== null && _savedSearch$columns !== void 0 ? _savedSearch$columns : [],
    grid: (_savedSearch$grid = savedSearch.grid) !== null && _savedSearch$grid !== void 0 ? _savedSearch$grid : {},
    hideChart: (_savedSearch$hideChar = savedSearch.hideChart) !== null && _savedSearch$hideChar !== void 0 ? _savedSearch$hideChar : false,
    isTextBasedQuery: (_savedSearch$isTextBa = savedSearch.isTextBasedQuery) !== null && _savedSearch$isTextBa !== void 0 ? _savedSearch$isTextBa : false,
    usesAdHocDataView: savedSearch.usesAdHocDataView,
    serializedSearchSource: (_savedSearch$searchSo = savedSearch.searchSource.getSerializedFields()) !== null && _savedSearch$searchSo !== void 0 ? _savedSearch$searchSo : {},
    viewMode: savedSearch.viewMode,
    hideAggregatedPreview: savedSearch.hideAggregatedPreview,
    rowHeight: savedSearch.rowHeight,
    headerRowHeight: savedSearch.headerRowHeight,
    timeRestore: savedSearch.timeRestore,
    timeRange: savedSearch.timeRange,
    refreshInterval: savedSearch.refreshInterval,
    rowsPerPage: savedSearch.rowsPerPage,
    sampleSize: savedSearch.sampleSize && savedSearch.sampleSize === allowedSampleSize ? savedSearch.sampleSize : undefined,
    breakdownField: savedSearch.breakdownField,
    density: savedSearch.density,
    visContext: savedSearch.visContext,
    controlGroupJson: savedSearch.controlGroupJson
  };
};
exports.fromSavedSearchToSavedObjectTab = fromSavedSearchToSavedObjectTab;