"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerDataViewManagement = DataVisualizerDataViewManagement;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _kibana_context = require("../../../kibana_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/components/data_view_management/data_view_management.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DataVisualizerDataViewManagement(props) {
  const {
    services: {
      dataViewFieldEditor,
      application
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    currentDataView
  } = props;
  const dataViewFieldEditPermission = dataViewFieldEditor === null || dataViewFieldEditor === void 0 ? void 0 : dataViewFieldEditor.userPermissions.editIndexPattern();
  const canEditDataViewField = !!dataViewFieldEditPermission;
  const [isAddDataViewFieldPopoverOpen, setIsAddDataViewFieldPopoverOpen] = (0, _react.useState)(false);
  const closeFieldEditor = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    return () => {
      // Make sure to close the editor when unmounting
      if (closeFieldEditor.current) {
        closeFieldEditor.current();
      }
    };
  }, []);
  if (dataViewFieldEditor === undefined || !currentDataView || !canEditDataViewField) {
    return null;
  }
  const addField = async () => {
    closeFieldEditor.current = await dataViewFieldEditor.openEditor({
      ctx: {
        dataView: currentDataView
      },
      onSave: () => {
        const refresh = {
          lastRefresh: Date.now()
        };
        _mlDatePicker.mlTimefilterRefresh$.next(refresh);
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "s",
    isOpen: isAddDataViewFieldPopoverOpen,
    closePopover: () => {
      setIsAddDataViewFieldPopoverOpen(false);
    },
    ownFocus: true,
    "data-test-subj": "dataVisualizerDataViewManagementPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      iconType: "boxesHorizontal",
      "data-test-subj": "dataVisualizerDataViewManagementButton",
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.index.dataViewManagement.actionsPopoverLabel', {
        defaultMessage: 'Data view settings'
      }),
      onClick: () => {
        setIsAddDataViewFieldPopoverOpen(!isAddDataViewFieldPopoverOpen);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "dataVisualizerDataViewManagementMenu",
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "add",
      icon: "indexOpen",
      "data-test-subj": "dataVisualizerAddDataViewFieldAction",
      onClick: () => {
        setIsAddDataViewFieldPopoverOpen(false);
        addField();
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.dataVisualizer.index.dataViewManagement.addFieldButton', {
      defaultMessage: 'Add field to data view'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "manage",
      icon: "indexSettings",
      "data-test-subj": "dataVisualizerManageDataViewAction",
      onClick: () => {
        var _props$currentDataVie;
        setIsAddDataViewFieldPopoverOpen(false);
        application.navigateToApp('management', {
          path: `/kibana/dataViews/dataView/${(_props$currentDataVie = props.currentDataView) === null || _props$currentDataVie === void 0 ? void 0 : _props$currentDataVie.id}`
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.dataVisualizer.index.dataViewManagement.manageFieldButton', {
      defaultMessage: 'Manage data view fields'
    }))],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }));
}