"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Axes = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _kibana_context = require("../../../kibana_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/doc_count_chart/axes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// round to 2dp
function tickFormatter(d) {
  return (Math.round(d * 100) / 100).toString();
}
const Axes = ({
  chartData
}) => {
  const yDomain = getYRange(chartData);
  const {
    services: {
      fieldFormats
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const xAxisFormatter = fieldFormats.deserialize({
    id: 'date'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: value => xAxisFormatter.convert(value),
    labelFormat: () => '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: _charts.Position.Left,
    tickFormat: tickFormatter,
    domain: yDomain,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }));
};
exports.Axes = Axes;
function getYRange(chartData) {
  const fit = false;
  if (chartData === undefined) {
    return {
      fit,
      min: NaN,
      max: NaN
    };
  }
  if (chartData.length === 0) {
    return {
      min: 0,
      max: 0,
      fit
    };
  }
  let max = Number.MIN_VALUE;
  let min = Number.MAX_VALUE;
  chartData.forEach(r => {
    max = Math.max(r.value, max);
    min = Math.min(r.value, min);
  });
  const padding = (max - min) * 0.1;
  max += padding;
  min -= padding;
  return {
    min,
    max,
    fit
  };
}