"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginWrapper = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _coreDi = require("@kbn/core-di");
var _coreDiInternal = require("@kbn/core-di-internal");
var _plugin_reader = require("./plugin_reader");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Lightweight wrapper around discovered plugin that is responsible for instantiating
 * plugin and dispatching proper context and dependencies into plugin's lifecycle hooks.
 *
 * @internal
 */
class PluginWrapper {
  constructor(discoveredPlugin, opaqueId, initializerContext) {
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "configPath", void 0);
    (0, _defineProperty2.default)(this, "requiredPlugins", void 0);
    (0, _defineProperty2.default)(this, "optionalPlugins", void 0);
    (0, _defineProperty2.default)(this, "runtimePluginDependencies", void 0);
    (0, _defineProperty2.default)(this, "definition", void 0);
    (0, _defineProperty2.default)(this, "instance", void 0);
    (0, _defineProperty2.default)(this, "container", void 0);
    (0, _defineProperty2.default)(this, "startDependencies$", new _rxjs.Subject());
    (0, _defineProperty2.default)(this, "startDependencies", (0, _rxjs.firstValueFrom)(this.startDependencies$));
    this.discoveredPlugin = discoveredPlugin;
    this.opaqueId = opaqueId;
    this.initializerContext = initializerContext;
    this.name = discoveredPlugin.id;
    this.configPath = discoveredPlugin.configPath;
    this.requiredPlugins = discoveredPlugin.requiredPlugins;
    this.optionalPlugins = discoveredPlugin.optionalPlugins;
    this.runtimePluginDependencies = discoveredPlugin.runtimePluginDependencies;
  }

  /**
   * Instantiates plugin and calls `setup` function exposed by the plugin initializer.
   * @param setupContext Context that consists of various core services tailored specifically
   * for the `setup` lifecycle event.
   * @param plugins The dictionary where the key is the dependency name and the value
   * is the contract returned by the dependency's `setup` function.
   */
  setup(setupContext, plugins) {
    var _this$instance, _this$container;
    this.definition = (0, _plugin_reader.read)(this.name);
    this.instance = this.createPluginInstance();
    if (this.definition.module) {
      this.container = setupContext.injection.getContainer();
      this.container.loadSync(this.definition.module);
      this.container.loadSync((0, _coreDiInternal.createSetupModule)(this.initializerContext, setupContext, plugins));
    }
    return [(_this$instance = this.instance) === null || _this$instance === void 0 ? void 0 : _this$instance.setup(setupContext, plugins), (_this$container = this.container) === null || _this$container === void 0 ? void 0 : _this$container.get(_coreDi.Setup)].find(Boolean);
  }

  /**
   * Calls `setup` function exposed by the initialized plugin.
   * @param startContext Context that consists of various core services tailored specifically
   * for the `start` lifecycle event.
   * @param plugins The dictionary where the key is the dependency name and the value
   * is the contract returned by the dependency's `start` function.
   */
  start(startContext, plugins) {
    var _this$container2, _this$instance2, _this$container3;
    if (this.definition === undefined) {
      throw new Error(`Plugin "${this.name}" can't be started since it isn't set up.`);
    }
    (_this$container2 = this.container) === null || _this$container2 === void 0 ? void 0 : _this$container2.loadSync((0, _coreDiInternal.createStartModule)(startContext, plugins));
    const contract = [(_this$instance2 = this.instance) === null || _this$instance2 === void 0 ? void 0 : _this$instance2.start(startContext, plugins), (_this$container3 = this.container) === null || _this$container3 === void 0 ? void 0 : _this$container3.get(_coreDi.Start)].find(Boolean);
    this.startDependencies$.next([startContext, plugins, contract]);
    return contract;
  }

  /**
   * Calls optional `stop` function exposed by the plugin initializer.
   */
  async stop() {
    var _this$instance3, _this$instance3$stop, _this$container4;
    if (this.definition === undefined) {
      throw new Error(`Plugin "${this.name}" can't be stopped since it isn't set up.`);
    }
    await ((_this$instance3 = this.instance) === null || _this$instance3 === void 0 ? void 0 : (_this$instance3$stop = _this$instance3.stop) === null || _this$instance3$stop === void 0 ? void 0 : _this$instance3$stop.call(_this$instance3));
    await ((_this$container4 = this.container) === null || _this$container4 === void 0 ? void 0 : _this$container4.unbindAll());
    this.instance = undefined;
    this.container = undefined;
  }
  createPluginInstance() {
    var _this$definition;
    if (!((_this$definition = this.definition) !== null && _this$definition !== void 0 && _this$definition.plugin)) {
      return;
    }
    const initializer = this.definition.plugin;
    const instance = initializer(this.initializerContext);
    if (typeof instance.setup !== 'function') {
      throw new Error(`Instance of plugin "${this.name}" does not define "setup" function.`);
    } else if (typeof instance.start !== 'function') {
      throw new Error(`Instance of plugin "${this.name}" does not define "start" function.`);
    }
    return instance;
  }
}
exports.PluginWrapper = PluginWrapper;