"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConsoleAppender = void 0;
var _securityHardening = require("@kbn/security-hardening");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 *
 * Appender that formats all the `LogRecord` instances it receives and logs them via built-in `console`.
 * @internal
 */
class ConsoleAppender {
  /**
   * Creates ConsoleAppender instance.
   * @param layout Instance of `Layout` sub-class responsible for `LogRecord` formatting.
   */
  constructor(layout) {
    this.layout = layout;
  }

  /**
   * Formats specified `record` and logs it via built-in `console`.
   * @param record `LogRecord` instance to be logged.
   */
  append(record) {
    // eslint-disable-next-line @kbn/eslint/no_unsafe_console
    _securityHardening.unsafeConsole.log(this.layout.format(record));
  }

  /**
   * Disposes `ConsoleAppender`.
   */
  dispose() {
    // noop
  }
}
exports.ConsoleAppender = ConsoleAppender;