"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyFixedLayout = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _legacy_fixed_global_app_style = require("./legacy_fixed_global_app_style");
var _app_containers = require("../../app_containers");
var _app_fixed_viewport = require("../../app_fixed_viewport");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/layout/core-chrome-layout/layouts/legacy-fixed/legacy_fixed_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Service for providing layout component wired to other core services.
 */
class LegacyFixedLayout {
  constructor(deps, params) {
    this.deps = deps;
    this.params = params;
  }

  /**
   * Returns a layout component with the provided dependencies
   */
  getComponent() {
    var _this$params$projectS;
    const {
      chrome,
      overlays,
      application
    } = this.deps;
    const chromeHeader = chrome.getLegacyHeaderComponentForFixedLayout({
      projectSideNavVersion: (_this$params$projectS = this.params.projectSideNavVersion) !== null && _this$params$projectS !== void 0 ? _this$params$projectS : 'v1'
    });
    const bannerComponent = overlays.banners.getComponent();
    const appComponent = application.getComponent();
    const chromeVisible$ = chrome.getIsVisible$();
    return /*#__PURE__*/_react.default.memo(() => {
      // TODO: Get rid of observables https://github.com/elastic/kibana/issues/225265
      const chromeVisible = (0, _useObservable.default)(chromeVisible$, false);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_legacy_fixed_global_app_style.LegacyFixedLayoutGlobalStyles, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 12
        }
      }), chromeHeader, /*#__PURE__*/_react.default.createElement("div", {
        id: "globalBannerList",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 11
        }
      }, bannerComponent), /*#__PURE__*/_react.default.createElement(_app_containers.AppWrapper, {
        chromeVisible: chromeVisible,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        id: _app_fixed_viewport.APP_FIXED_VIEWPORT_ID,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 13
        }
      }), appComponent));
    });
  }
}
exports.LegacyFixedLayout = LegacyFixedLayout;