"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTourSteps = getTourSteps;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/containers/main/get_tour_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const commonProps = {
  stepsTotal: 5,
  maxWidth: 400
};
function getTourSteps(docLinks) {
  return [{
    step: 1,
    title: _i18n.i18n.translate('console.tour.shellStepTitle', {
      defaultMessage: 'Welcome to the Console'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('console.tour.shellStepContent', {
      defaultMessage: 'Console is an interactive UI for calling Elasticsearch and Kibana APIs and viewing their responses. Use Query DSL syntax to search your data, manage settings, and more.'
    })),
    anchorPosition: 'downLeft',
    'data-test-subj': 'shellTourStep',
    ...commonProps
  }, {
    step: 2,
    title: _i18n.i18n.translate('console.tour.editorStepTitle', {
      defaultMessage: 'Get started querying'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "console.tour.editorStepContent",
      defaultMessage: "Enter a request in this input pane, and view the response in the adjacent output pane. For more details, visit {queryDslDocs}.",
      values: {
        queryDslDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.query.queryDsl,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 53,
            columnNumber: 17
          }
        }, "QueryDSL documentation")
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 11
      }
    })),
    anchorPosition: 'rightUp',
    'data-test-subj': 'editorTourStep',
    css: {
      position: 'absolute',
      top: '40%',
      left: '15%',
      transform: 'translateY(10px)'
    },
    ...commonProps
  }, {
    step: 3,
    title: _i18n.i18n.translate('console.tour.historyStepTitle', {
      defaultMessage: 'Revisit past queries'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('console.tour.historyStepContent', {
      defaultMessage: 'The history panel keeps track of your past queries, making it easy to review and rerun them.'
    })),
    anchorPosition: 'rightUp',
    'data-test-subj': 'historyTourStep',
    ...commonProps
  }, {
    step: 4,
    title: _i18n.i18n.translate('console.tour.configStepTitle', {
      defaultMessage: 'Customize your toolbox'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('console.tour.configStepContent', {
      defaultMessage: 'Fine-tune your Console’s settings and create variables to personalize your workflow.'
    })),
    anchorPosition: 'rightUp',
    'data-test-subj': 'configTourStep',
    ...commonProps
  }, {
    step: 5,
    title: _i18n.i18n.translate('console.tour.filesStepTitle', {
      defaultMessage: 'Manage Console files'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('console.tour.filesStepContent', {
      defaultMessage: 'Easily export your Console requests to a file, or import ones you’ve saved previously.'
    })),
    anchorPosition: 'downRight',
    'data-test-subj': 'filesTourStep',
    ...commonProps
  }];
}