"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VariableEditorForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _shared_imports = require("../../../shared_imports");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/components/variables/variables_editor_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const styles = {
  fullWidthPanel: (0, _react2.css)`
    width: 100%;
  `
};
const fieldsConfig = {
  variableName: {
    label: _i18n.i18n.translate('console.variablesPage.form.variableNameFieldLabel', {
      defaultMessage: 'Variable name'
    }),
    validations: [{
      validator: ({
        value
      }) => {
        if (value.trim() === '') {
          return {
            message: _i18n.i18n.translate('console.variablesPage.form.variableNameRequiredLabel', {
              defaultMessage: 'This is a required field'
            })
          };
        }
        if (!(0, _utils.isValidVariableName)(value)) {
          return {
            message: _i18n.i18n.translate('console.variablesPage.form.variableNameInvalidLabel', {
              defaultMessage: 'Only letters, numbers and underscores are allowed'
            })
          };
        }
      }
    }]
  },
  value: {
    label: _i18n.i18n.translate('console.variablesPage.form.valueFieldLabel', {
      defaultMessage: 'Value'
    }),
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('console.variablesPage.form.valueRequiredLabel', {
        defaultMessage: 'Value is required'
      }))
    }]
  }
};
const VariableEditorForm = props => {
  var _props$title;
  const onSubmit = async (data, isValid) => {
    if (isValid) {
      props.onSubmit({
        ...props.defaultValue,
        ...data,
        ...(props.defaultValue ? {} : {
          id: (0, _uuid.v4)()
        })
      });
    }
  };
  const {
    form
  } = (0, _shared_imports.useForm)({
    onSubmit,
    defaultValue: props.defaultValue
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasShadow: false,
    borderRadius: "none",
    grow: false,
    css: styles.fullWidthPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, (_props$title = props.title) !== null && _props$title !== void 0 ? _props$title : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Add a new variable",
    id: "console.variablesPage.addNewVariableTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.variableName,
    path: "name",
    component: _shared_imports.TextField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'nameField',
        placeholder: _i18n.i18n.translate('console.variablesPage.form.namePlaceholderLabel', {
          defaultMessage: 'exampleName'
        }),
        prepend: '${',
        append: '}'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.value,
    path: "value",
    component: _shared_imports.TextField,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'valueField',
        placeholder: _i18n.i18n.translate('console.variablesPage.form.valuePlaceholderLabel', {
          defaultMessage: 'exampleValue'
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => props.onCancel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.addNew.cancelButton",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "save",
    onClick: form.submit,
    "data-test-subj": "addNewVariableButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.addNew.submitButton",
    defaultMessage: "Save changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 17
    }
  })))))));
};
exports.VariableEditorForm = VariableEditorForm;