"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatestFindingsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _get_vendor_name = require("@kbn/cloud-security-posture/src/utils/get_vendor_name");
var _create_detection_rule_from_benchmark = require("@kbn/cloud-security-posture/src/utils/create_detection_rule_from_benchmark");
var TEST_SUBJECTS = _interopRequireWildcard(require("../test_subjects"));
var _findings_distribution_bar = require("../layout/findings_distribution_bar");
var _error_callout = require("../layout/error_callout");
var _cloud_security_data_table = require("../../../components/cloud_security_data_table");
var _constants = require("./constants");
var _use_latest_findings_table = require("./use_latest_findings_table");
var _timestamp_table_cell = require("../../../components/timestamp_table_cell");
var _findings_table_field_labels = require("./findings_table_field_labels");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/configurations/latest_findings/latest_findings_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Type Guard for checking if the given source is a CspFinding
 */
const isCspFinding = source => {
  var _source$data_stream;
  return (source === null || source === void 0 ? void 0 : (_source$data_stream = source.data_stream) === null || _source$data_stream === void 0 ? void 0 : _source$data_stream.dataset) !== undefined;
};
const getCspFinding = source => {
  if (isCspFinding(source)) return source;
};

/**
 * Flyout component for the latest findings table, renders empty component as now we use Use Expandable Flyout API hook to handle all the rendering
 */
const onOpenFlyoutCallback = () => {
  _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, _ui_metrics.OPEN_FINDINGS_FLYOUT);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
};
const title = _i18n.i18n.translate('xpack.csp.findings.latestFindings.tableRowTypeLabel', {
  defaultMessage: 'Findings'
});
const customCellRenderer = rows => ({
  'result.evaluation': ({
    rowIndex
  }) => {
    var _finding$result;
    const finding = getCspFinding(rows[rowIndex].raw._source);
    return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CspEvaluationBadge, {
      type: finding === null || finding === void 0 ? void 0 : (_finding$result = finding.result) === null || _finding$result === void 0 ? void 0 : _finding$result.evaluation,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 12
      }
    });
  },
  'observer.vendor': ({
    rowIndex
  }) => {
    const finding = getCspFinding(rows[rowIndex].raw._source);
    if (!finding) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '');
    const vendor = (0, _get_vendor_name.getVendorName)(finding);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, vendor || '');
  },
  '@timestamp': ({
    rowIndex
  }) => {
    const finding = getCspFinding(rows[rowIndex].raw._source);
    if (!(finding !== null && finding !== void 0 && finding['@timestamp'])) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
    return /*#__PURE__*/_react.default.createElement(_timestamp_table_cell.TimestampTableCell, {
      timestamp: finding['@timestamp'],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 12
      }
    });
  }
});
const LatestFindingsTable = ({
  groupSelectorComponent,
  height,
  showDistributionBar = true,
  nonPersistedFilters
}) => {
  const {
    cloudPostureDataTable,
    rows,
    error,
    isFetching,
    isLoading,
    fetchNextPage,
    passed,
    failed,
    total,
    canShowDistributionBar,
    onDistributionBarClick
  } = (0, _use_latest_findings_table.useLatestFindingsTable)({
    getDefaultQuery: _constants.getDefaultQuery,
    nonPersistedFilters,
    showDistributionBar
  });
  const createMisconfigurationRuleFn = rowIndex => {
    const finding = getCspFinding(rows[rowIndex].raw._source);
    if (!finding) return;
    return async http => (0, _create_detection_rule_from_benchmark.createDetectionRuleFromBenchmarkRule)(http, finding.rule);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": TEST_SUBJECTS.LATEST_FINDINGS_CONTAINER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  }, error ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, {
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, canShowDistributionBar && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_findings_distribution_bar.FindingsDistributionBar, {
    distributionOnClick: onDistributionBarClick,
    passed: passed,
    failed: failed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_cloud_security_data_table.CloudSecurityDataTable, {
    "data-test-subj": TEST_SUBJECTS.LATEST_FINDINGS_TABLE,
    isLoading: isFetching || isLoading,
    defaultColumns: _constants.defaultColumns,
    rows: rows,
    total: total,
    onOpenFlyoutCallback: onOpenFlyoutCallback,
    cloudPostureDataTable: cloudPostureDataTable,
    loadMore: fetchNextPage,
    title: title,
    customCellRenderer: customCellRenderer,
    groupSelectorComponent: groupSelectorComponent,
    height: height,
    createRuleFn: createMisconfigurationRuleFn,
    columnHeaders: _findings_table_field_labels.findingsTableFieldLabels,
    flyoutType: "misconfiguration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  })));
};
exports.LatestFindingsTable = LatestFindingsTable;