"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showCreateDetectionRuleSuccessToast = exports.showCreateDetectionRuleErrorToast = exports.TakeAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _test_subjects = require("./test_subjects");
var _use_kibana = require("../common/hooks/use_kibana");
var _constants = require("../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/take_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RULE_PAGE_PATH = '/app/security/rules/id/';
const showCreateDetectionRuleErrorToast = (cloudSecurityStartServices, error) => {
  return cloudSecurityStartServices.notifications.toasts.addDanger({
    title: _i18n.i18n.translate('xpack.csp.takeAction.createRuleErrorTitle', {
      defaultMessage: 'Unable to create detection rule'
    }),
    text: _i18n.i18n.translate('xpack.csp.takeAction.createRuleErrorDescription', {
      defaultMessage: 'An error occurred while creating the detection rule: {errorMessage}.',
      values: {
        errorMessage: error.message
      }
    }),
    'data-test-subj': 'csp:toast-error'
  });
};
exports.showCreateDetectionRuleErrorToast = showCreateDetectionRuleErrorToast;
const showCreateDetectionRuleSuccessToast = (cloudSecurityStartServices, http, ruleResponse) => {
  const {
    notifications,
    analytics,
    i18n,
    theme
  } = cloudSecurityStartServices;
  const startServices = {
    analytics,
    i18n,
    theme
  };
  return notifications.toasts.addSuccess({
    toastLifeTimeMs: 10000,
    color: 'success',
    iconType: '',
    'data-test-subj': 'csp:toast-success',
    title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": "csp:toast-success-title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }, ruleResponse.name), ` `, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleCreatedToastTitle",
      defaultMessage: "detection rule was created.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleCreatedToast",
      defaultMessage: "Add rule actions to get notified when alerts are generated.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }))), startServices),
    text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "csp:toast-success-link",
      size: "s",
      href: http.basePath.prepend(RULE_PAGE_PATH + ruleResponse.id),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.flyout.ruleCreatedToastViewRuleButton",
      defaultMessage: "View rule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 15
      }
    }))))), startServices)
  });
};

/*
 * This component is used to create a detection rule from Flyout.
 * It accepts a createRuleFn parameter which is used to create a rule in a generic way.
 */
exports.showCreateDetectionRuleSuccessToast = showCreateDetectionRuleSuccessToast;
const TakeAction = ({
  createRuleFn,
  enableBenchmarkRuleFn,
  disableBenchmarkRuleFn,
  isCreateDetectionRuleDisabled = false,
  isDataGridControlColumn: isDataTableAction = false
}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const closePopover = () => {
    setPopoverOpen(false);
  };
  const smallContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'smallContextMenuPopover'
  });
  const button = !isDataTableAction ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    fill: true,
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setPopoverOpen(!isPopoverOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.flyout.takeActionButton",
    defaultMessage: "Take action",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.csp.flyout.moreActionsButton', {
      defaultMessage: 'More actions'
    }),
    iconType: "boxesHorizontal",
    color: "primary",
    isLoading: isLoading,
    onClick: () => setPopoverOpen(!isPopoverOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  });
  const actionsItems = [];
  if (createRuleFn) actionsItems.push(/*#__PURE__*/_react.default.createElement(CreateDetectionRule, {
    key: "createRule",
    createRuleFn: createRuleFn,
    setIsLoading: setIsLoading,
    closePopover: closePopover,
    queryClient: queryClient,
    isCreateDetectionRuleDisabled: isCreateDetectionRuleDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }));
  if (enableBenchmarkRuleFn) actionsItems.push(/*#__PURE__*/_react.default.createElement(EnableBenchmarkRule, {
    key: "enableBenchmarkRule",
    enableBenchmarkRuleFn: enableBenchmarkRuleFn,
    setIsLoading: setIsLoading,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }));
  if (disableBenchmarkRuleFn) actionsItems.push(/*#__PURE__*/_react.default.createElement(DisableBenchmarkRule, {
    key: "disableBenchmarkRule",
    disableBenchmarkRuleFn: disableBenchmarkRuleFn,
    setIsLoading: setIsLoading,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: smallContextMenuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    "data-test-subj": _test_subjects.TAKE_ACTION_SUBJ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: actionsItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }));
};
exports.TakeAction = TakeAction;
const CreateDetectionRule = ({
  createRuleFn,
  setIsLoading,
  closePopover,
  queryClient,
  isCreateDetectionRuleDisabled = false
}) => {
  const {
    http,
    ...startServices
  } = (0, _use_kibana.useKibana)().services;
  const {
    mutate
  } = (0, _reactQuery.useMutation)({
    mutationFn: () => {
      return createRuleFn(http);
    },
    onMutate: () => {
      setIsLoading(true);
      closePopover();
    },
    onSuccess: ruleResponse => {
      showCreateDetectionRuleSuccessToast(startServices, http, ruleResponse);
      // Triggering a refetch of rules and alerts to update the UI
      queryClient.invalidateQueries([_constants.DETECTION_ENGINE_RULES_KEY]);
      queryClient.invalidateQueries([_constants.DETECTION_ENGINE_ALERTS_KEY]);
    },
    onError: error => {
      showCreateDetectionRuleErrorToast(startServices, error);
    },
    onSettled: () => {
      setIsLoading(false);
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "createRule",
    disabled: isCreateDetectionRuleDisabled,
    onClick: () => {
      mutate();
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.CREATE_DETECTION_FROM_TABLE_ROW_ACTION);
    },
    "data-test-subj": _test_subjects.CREATE_RULE_ACTION_SUBJ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Create a detection rule",
    id: "xpack.csp.createDetectionRuleButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }));
};
const EnableBenchmarkRule = ({
  enableBenchmarkRuleFn,
  setIsLoading,
  closePopover
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "enableBenchmarkRule",
    onClick: async () => {
      closePopover();
      setIsLoading(true);
      await enableBenchmarkRuleFn();
      setIsLoading(false);
    },
    "data-test-subj": 'enable-benchmark-rule-take-action-button',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Enable Rule",
    id: "xpack.csp.enableBenchmarkRuleButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 7
    }
  }));
};
const DisableBenchmarkRule = ({
  disableBenchmarkRuleFn,
  setIsLoading,
  closePopover
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "disableBenchmarkRule",
    onClick: async () => {
      closePopover();
      setIsLoading(true);
      await disableBenchmarkRuleFn();
      setIsLoading(false);
    },
    "data-test-subj": 'disable-benchmark-rule-take-action-button',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Disable Rule",
    id: "xpack.csp.disableBenchmarkRuleButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }));
};