"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CnvmKspmTemplateInfo = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/fleet_extensions/cnvm_kspm/cnvm_kspm_info.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CnvmKspmTemplateInfo = ({
  policyTemplate
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "subdued",
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 18,
    columnNumber: 3
  }
}, policyTemplate === _cloudSecurityPostureCommon.KSPM_POLICY_TEMPLATE && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.fleetIntegration.configureKspmIntegrationDescription",
  defaultMessage: "Select the Kubernetes cluster type you want to monitor and then fill in the name and description to help identify this integration",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 20,
    columnNumber: 7
  }
}), policyTemplate === _constants.VULN_MGMT_POLICY_TEMPLATE && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  iconType: "info",
  color: "primary",
  "data-test-subj": "additionalChargeCalloutTestSubj",
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.cnvm.additionalChargesCalloutTitle",
    defaultMessage: "Additional charges on cloud provider billing account.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 13
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 11
  }
}, /*#__PURE__*/_react.default.createElement("p", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.fleetIntegration.cnvm.additionalChargesCalloutDescription",
  defaultMessage: "Please note that using this service may result in additional charges on your next cloud provider billing statement due to increased usage.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 15
  }
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.fleetIntegration.cnvm.awsSupportText",
  defaultMessage: "We currently support <b>AWS(Amazon Web Services)</b> cloud provider",
  values: {
    b: chunks => /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 28
      }
    }, chunks)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.fleetIntegration.cnvm.chooseNameAndDescriptionText",
  defaultMessage: "Choose a name and description to help identify this integration",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 9
  }
})));
exports.CnvmKspmTemplateInfo = CnvmKspmTemplateInfo;