"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShouldDisableStatus = void 0;
var _react = require("react");
var _domain = require("../../../../common/types/domain");
var _use_user_permissions = require("../../user_actions/use_user_permissions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useShouldDisableStatus = () => {
  const {
    canUpdate,
    canReopenCase
  } = (0, _use_user_permissions.useUserPermissions)();
  const shouldDisableStatusFn = (0, _react.useCallback)(selectedCases => {
    // Read Only + Disabled => Cannot do anything
    const missingAllUpdatePermissions = !canUpdate && !canReopenCase;
    if (missingAllUpdatePermissions) return true;

    // All + Enabled reopen => can change status at any point in any way
    if (canUpdate && canReopenCase) return false;
    const selectedCasesContainsClosed = selectedCases.some(theCase => theCase.status === _domain.CaseStatuses.closed);
    if (selectedCasesContainsClosed) {
      return !canReopenCase;
    } else {
      return !canUpdate;
    }
  }, [canReopenCase, canUpdate]);
  return shouldDisableStatusFn;
};
exports.useShouldDisableStatus = useShouldDisableStatus;