"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateColorStop = exports.transformPaletteToColorStops = exports.reduceColorsByStopsSize = exports.mergeColorStopsWithPalette = exports.getOverridenPaletteOptions = exports.deleteColorStop = exports.createColorStop = exports.addNewColorStop = void 0;
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const id = (0, _eui.htmlIdGenerator)();
const getOverridenPaletteOptions = () => ({
  range: 'number',
  continuity: 'below'
});
exports.getOverridenPaletteOptions = getOverridenPaletteOptions;
const createColorStop = (stop = 0, color = '') => ({
  stop,
  color,
  id: id()
});
exports.createColorStop = createColorStop;
const transformPaletteToColorStops = ({
  stops = [],
  colors
}) => (0, _lodash.zip)(stops, colors).map(([stop, color]) => createColorStop(stop, color));
exports.transformPaletteToColorStops = transformPaletteToColorStops;
const mergeColorStopsWithPalette = palette => colorStops => {
  const stopsWithColors = colorStops.reduce((acc, {
    color,
    stop
  }) => {
    acc.colors.push(color !== null && color !== void 0 ? color : '');
    acc.stops.push(stop);
    return acc;
  }, {
    colors: [],
    stops: []
  });
  return {
    ...palette,
    ...stopsWithColors
  };
};
exports.mergeColorStopsWithPalette = mergeColorStopsWithPalette;
const updateColorStop = (index, colorStop) => colorStops => {
  colorStops.splice(index, 1, colorStop);
  return colorStops;
};
exports.updateColorStop = updateColorStop;
const deleteColorStop = index => colorStops => {
  colorStops.splice(index, 1);
  return colorStops;
};
exports.deleteColorStop = deleteColorStop;
const addNewColorStop = palette => colorStops => {
  const lastColorStopIndex = colorStops.length - 1;
  const lastStop = lastColorStopIndex >= 0 ? colorStops[lastColorStopIndex].stop + 1 : 0;
  const newIndex = lastColorStopIndex + 1;
  return [...colorStops, {
    stop: lastStop,
    color: palette.colors.length > newIndex + 1 ? palette.colors[newIndex] : palette.colors[palette.colors.length - 1]
  }];
};
exports.addNewColorStop = addNewColorStop;
const reduceColorsByStopsSize = (colors = [], stopsSize) => {
  var _reducedColors;
  const reducedColors = (0, _lodash.take)(colors, stopsSize);
  const colorsLength = reducedColors.length;
  if (colorsLength === stopsSize) {
    return reducedColors;
  }
  return [...reducedColors, ...Array(stopsSize - colorsLength).fill((_reducedColors = reducedColors[colorsLength - 1]) !== null && _reducedColors !== void 0 ? _reducedColors : '')];
};
exports.reduceColorsByStopsSize = reduceColorsByStopsSize;