"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadTableTools = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _confirm_modal = require("../../confirm_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/home/my_workpads/workpad_table_tools.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WorkpadTableTools = ({
  workpads,
  canUserWrite,
  selectedWorkpadIds,
  onDeleteWorkpads,
  onExportWorkpads
}) => {
  var _workpads$find;
  const [isDeletePending, setIsDeletePending] = (0, _react.useState)(false);
  const openRemoveConfirm = () => setIsDeletePending(true);
  const closeRemoveConfirm = () => setIsDeletePending(false);
  let deleteButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    iconType: "trash",
    onClick: openRemoveConfirm,
    disabled: !canUserWrite,
    "aria-label": strings.getDeleteButtonAriaLabel(selectedWorkpadIds.length),
    "data-test-subj": "deleteWorkpadButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, strings.getDeleteButtonLabel(selectedWorkpadIds.length));
  const downloadButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    onClick: () => onExportWorkpads(selectedWorkpadIds),
    iconType: "exportAction",
    "aria-label": strings.getExportButtonAriaLabel(selectedWorkpadIds.length),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, strings.getExportButtonLabel(selectedWorkpadIds.length));
  if (!canUserWrite) {
    deleteButton = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: strings.getNoPermissionToDeleteToolTip(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    }, deleteButton);
  }
  const modalTitle = selectedWorkpadIds.length === 1 ? strings.getDeleteSingleWorkpadModalTitle(((_workpads$find = workpads.find(workpad => workpad.id === selectedWorkpadIds[0])) === null || _workpads$find === void 0 ? void 0 : _workpads$find.name) || '') : strings.getDeleteMultipleWorkpadModalTitle(selectedWorkpadIds.length + '');
  const confirmModal = /*#__PURE__*/_react.default.createElement(_confirm_modal.ConfirmModal, {
    isOpen: isDeletePending,
    title: modalTitle,
    message: strings.getDeleteModalDescription(),
    confirmButtonText: strings.getDeleteModalConfirmButtonLabel(),
    onConfirm: () => {
      onDeleteWorkpads(selectedWorkpadIds);
      closeRemoveConfirm();
    },
    onCancel: closeRemoveConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, downloadButton), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, deleteButton)), confirmModal);
};
exports.WorkpadTableTools = WorkpadTableTools;
const strings = {
  getDeleteButtonAriaLabel: numberOfWorkpads => _i18n.i18n.translate('xpack.canvas.workpadTableTools.deleteButtonAriaLabel', {
    defaultMessage: 'Delete {numberOfWorkpads} workpads',
    values: {
      numberOfWorkpads
    }
  }),
  getDeleteButtonLabel: numberOfWorkpads => _i18n.i18n.translate('xpack.canvas.workpadTableTools.deleteButtonLabel', {
    defaultMessage: 'Delete ({numberOfWorkpads})',
    values: {
      numberOfWorkpads
    }
  }),
  getDeleteModalConfirmButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadTableTools.deleteModalConfirmButtonLabel', {
    defaultMessage: 'Delete'
  }),
  getDeleteModalDescription: () => _i18n.i18n.translate('xpack.canvas.workpadTableTools.deleteModalDescription', {
    defaultMessage: `You can't recover deleted workpads.`
  }),
  getDeleteMultipleWorkpadModalTitle: numberOfWorkpads => _i18n.i18n.translate('xpack.canvas.workpadTableTools.deleteMultipleWorkpadsModalTitle', {
    defaultMessage: 'Delete {numberOfWorkpads} workpads?',
    values: {
      numberOfWorkpads
    }
  }),
  getDeleteSingleWorkpadModalTitle: workpadName => _i18n.i18n.translate('xpack.canvas.workpadTableTools.deleteSingleWorkpadModalTitle', {
    defaultMessage: `Delete workpad ''{workpadName}''?`,
    values: {
      workpadName
    }
  }),
  getExportButtonAriaLabel: numberOfWorkpads => _i18n.i18n.translate('xpack.canvas.workpadTableTools.exportButtonAriaLabel', {
    defaultMessage: 'Export {numberOfWorkpads} workpads',
    values: {
      numberOfWorkpads
    }
  }),
  getExportButtonLabel: numberOfWorkpads => _i18n.i18n.translate('xpack.canvas.workpadTableTools.exportButtonLabel', {
    defaultMessage: 'Export ({numberOfWorkpads})',
    values: {
      numberOfWorkpads
    }
  }),
  getNoPermissionToCreateToolTip: () => _i18n.i18n.translate('xpack.canvas.workpadTableTools.noPermissionToCreateToolTip', {
    defaultMessage: `You don't have permission to create workpads`
  }),
  getNoPermissionToDeleteToolTip: () => _i18n.i18n.translate('xpack.canvas.workpadTableTools.noPermissionToDeleteToolTip', {
    defaultMessage: `You don't have permission to delete workpads`
  }),
  getNoPermissionToUploadToolTip: () => _i18n.i18n.translate('xpack.canvas.workpadTableTools.noPermissionToUploadToolTip', {
    defaultMessage: `You don't have permission to upload workpads`
  })
};