"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpanLinks = SpanLinks;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _kuery_bar = require("../kuery_bar");
var _span_links_callout = require("./span_links_callout");
var _span_links_table = require("./span_links_table");
var _use_local_storage = require("../../../hooks/use_local_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/span_links/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SpanLinks({
  spanLinksCount,
  traceId,
  spanId,
  processorEvent
}) {
  const {
    query: {
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view', '/traces/explorer/waterfall', '/dependencies/operation');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const [selectedLinkType, setSelectedLinkType] = (0, _react.useState)(spanLinksCount.linkedChildren ? 'children' : 'parents');
  const [spanLinksCalloutDismissed, setSpanLinksCalloutDismissed] = (0, _use_local_storage.useLocalStorage)('apm.spanLinksCalloutDismissed', false);
  const [kuery, setKuery] = (0, _react.useState)('');
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (selectedLinkType === 'children') {
      return callApmApi('GET /internal/apm/traces/{traceId}/span_links/{spanId}/children', {
        params: {
          path: {
            traceId,
            spanId
          },
          query: {
            kuery,
            start,
            end
          }
        }
      });
    }
    return callApmApi('GET /internal/apm/traces/{traceId}/span_links/{spanId}/parents', {
      params: {
        path: {
          traceId,
          spanId
        },
        query: {
          kuery,
          start,
          end,
          processorEvent
        }
      }
    });
  }, [selectedLinkType, kuery, traceId, spanId, start, end, processorEvent]);
  const selectOptions = (0, _react.useMemo)(() => [{
    value: 'children',
    text: _i18n.i18n.translate('xpack.apm.spanLinks.combo.childrenLinks', {
      defaultMessage: 'Incoming links ({linkedChildren})',
      values: {
        linkedChildren: spanLinksCount.linkedChildren
      }
    }),
    disabled: !spanLinksCount.linkedChildren
  }, {
    value: 'parents',
    text: _i18n.i18n.translate('xpack.apm.spanLinks.combo.parentsLinks', {
      defaultMessage: 'Outgoing links ({linkedParents})',
      values: {
        linkedParents: spanLinksCount.linkedParents
      }
    }),
    disabled: !spanLinksCount.linkedParents
  }], [spanLinksCount]);
  if (!data || (0, _use_fetcher.isPending)(status)) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: 'flex',
        justifyContent: 'center'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, !spanLinksCalloutDismissed && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_span_links_callout.SpanLinksCallout, {
    dismissCallout: () => {
      setSpanLinksCalloutDismissed(true);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_kuery_bar.KueryBar, {
    onSubmit: value => {
      setKuery(value);
    },
    value: kuery,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.apm.spanLinks.select.ariaLabel', {
      defaultMessage: 'Span link type selector'
    }),
    "data-test-subj": "spanLinkTypeSelect",
    options: selectOptions,
    value: selectedLinkType,
    onChange: e => {
      setSelectedLinkType(e.target.value);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_span_links_table.SpanLinksTable, {
    items: data.spanLinksDetails,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  })));
}