"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexLifecyclePhaseSelect = IndexLifecyclePhaseSelect;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _storage_explorer_types = require("../../../../common/storage_explorer_types");
var urlHelpers = _interopRequireWildcard(require("../../shared/links/url_helpers"));
var _use_apm_params = require("../../../hooks/use_apm_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/storage_explorer/index_lifecycle_phase_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function IndexLifecyclePhaseSelect() {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    query: {
      indexLifecyclePhase
    }
  } = (0, _use_apm_params.useApmParams)('/storage-explorer');
  const indexLifecyclePhaseLabel = _i18n.i18n.translate('xpack.apm.storageExplorer.indexLifecyclePhase.label', {
    defaultMessage: 'Index lifecycle phase'
  });
  const options = [{
    value: _storage_explorer_types.IndexLifecyclePhaseSelectOption.All,
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.indexLifecyclePhase.all.label', {
      defaultMessage: 'All'
    }),
    description: _i18n.i18n.translate('xpack.apm.storageExplorer.indexLifecyclePhase.all.description', {
      defaultMessage: 'Search data in all lifecycle phases.'
    })
  }, {
    value: _storage_explorer_types.IndexLifecyclePhaseSelectOption.Hot,
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.indexLifecyclePhase.hot.label', {
      defaultMessage: 'Hot'
    }),
    description: _i18n.i18n.translate('xpack.apm.storageExplorer.indexLifecyclePhase.hot.description', {
      defaultMessage: 'Holds your most-recent, most-frequently-searched data.'
    })
  }, {
    value: _storage_explorer_types.IndexLifecyclePhaseSelectOption.Warm,
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.indexLifecyclePhase.warm.label', {
      defaultMessage: 'Warm'
    }),
    description: _i18n.i18n.translate('xpack.apm.storageExplorer.indexLifecyclePhase.warm.description', {
      defaultMessage: 'Holds data from recent weeks. Updates are still allowed, but likely infrequent.'
    })
  }, {
    value: _storage_explorer_types.IndexLifecyclePhaseSelectOption.Cold,
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.indexLifecyclePhase.cold.label', {
      defaultMessage: 'Cold'
    }),
    description: _i18n.i18n.translate('xpack.apm.storageExplorer.indexLifecyclePhase.cold.description', {
      defaultMessage: 'While still searchable, this tier is typically optimized for lower storage costs rather than search speed.'
    })
  }, {
    value: _storage_explorer_types.IndexLifecyclePhaseSelectOption.Frozen,
    label: _i18n.i18n.translate('xpack.apm.storageExplorer.indexLifecyclePhase.frozen.label', {
      defaultMessage: 'Frozen'
    }),
    description: _i18n.i18n.translate('xpack.apm.storageExplorer.indexLifecyclePhase.frozen.description', {
      defaultMessage: 'Holds data that are no longer being queried, or being queried rarely.'
    })
  }].map(({
    value,
    label,
    description
  }) => ({
    value,
    inputDisplay: label,
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 11
      }
    }, description)))
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    prepend: indexLifecyclePhaseLabel,
    options: options,
    valueOfSelected: indexLifecyclePhase,
    onChange: value => {
      urlHelpers.push(history, {
        query: {
          indexLifecyclePhase: value
        }
      });
    },
    hasDividers: true,
    style: {
      minWidth: 200
    },
    "data-test-subj": "storageExplorerLifecyclePhaseSelect",
    "aria-label": indexLifecyclePhaseLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  });
}