"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddedMap = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _get_layer_list = require("./map_layers/get_layer_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/service_overview/geo_map/embedded_map.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function EmbeddedMapComponent({
  selectedMap,
  start,
  end,
  kuery = '',
  filters,
  dataView,
  styleColors = {
    lineColor: '',
    labelColor: '',
    labelOutlineColor: ''
  }
}) {
  const {
    maps
  } = (0, _public.useKibana)().services;
  const layerList = (0, _react.useMemo)(() => {
    return dataView !== null && dataView !== void 0 && dataView.id ? (0, _get_layer_list.getLayerList)({
      selectedMap,
      maps,
      dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id,
      styleColors
    }) : [];
  }, [selectedMap, maps, dataView === null || dataView === void 0 ? void 0 : dataView.id, styleColors]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "serviceOverviewEmbeddedMap",
    style: {
      width: '100%',
      height: '500px',
      display: 'flex',
      flex: '1 1 100%',
      zIndex: 1
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, maps && maps.Map({
    title: _i18n.i18n.translate('xpack.apm.serviceOverview.embeddedMap.input.title', {
      defaultMessage: 'Latency by country'
    }),
    filters,
    query: {
      query: kuery,
      language: 'kuery'
    },
    timeRange: {
      from: start,
      to: end
    },
    layerList,
    hideFilterActions: true,
    isLayerTOCOpen: false,
    mapCenter: {
      lat: 20.43425,
      lon: 0,
      zoom: 1.25
    }
  }));
}
EmbeddedMapComponent.displayName = 'EmbeddedMap';
const EmbeddedMap = exports.EmbeddedMap = /*#__PURE__*/_react.default.memo(EmbeddedMapComponent);