"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorSampler = ErrorSampler;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _url_helpers = require("../../../shared/links/url_helpers");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _error_sample_detail = require("./error_sample_detail");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/error_group_details/error_sampler/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ErrorSampler({
  errorSampleIds,
  errorSamplesFetchStatus,
  occurrencesCount
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    path: {
      groupId
    },
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/errors/{groupId}', '/mobile-services/{serviceName}/errors-and-crashes/errors/{groupId}', '/mobile-services/{serviceName}/errors-and-crashes/crashes/{groupId}');
  const {
    observabilityAIAssistant
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    rangeFrom,
    rangeTo,
    environment,
    kuery,
    errorId
  } = query;
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data: errorData,
    status: errorFetchStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end && errorId) {
      return callApmApi('GET /internal/apm/services/{serviceName}/errors/{groupId}/error/{errorId}', {
        params: {
          path: {
            serviceName,
            groupId,
            errorId
          },
          query: {
            environment,
            kuery,
            start,
            end
          }
        }
      });
    }
  }, [environment, kuery, serviceName, start, end, groupId, errorId]);
  const onSampleClick = sample => {
    history.push({
      ...history.location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(history.location.search),
        errorId: sample
      })
    });
  };
  const loadingErrorSamplesData = (0, _use_fetcher.isPending)(errorSamplesFetchStatus);
  (0, _react.useEffect)(() => {
    if (!errorData || !observabilityAIAssistant) {
      return;
    }
    return observabilityAIAssistant.service.setScreenContext({
      data: [{
        name: 'error_sample',
        description: 'The error document currently displayed',
        value: errorData
      }]
    });
  }, [observabilityAIAssistant, errorData]);
  if (loadingErrorSamplesData || !errorData) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        textAlign: 'center'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_error_sample_detail.ErrorSampleDetails, {
    onSampleClick: onSampleClick,
    errorSampleIds: errorSampleIds,
    errorSamplesFetchStatus: errorSamplesFetchStatus,
    errorData: errorData,
    errorFetchStatus: errorFetchStatus,
    occurrencesCount: occurrencesCount,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  });
}