"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmRuleParamsContainer = ApmRuleParamsContainer;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/ui_components/apm_rule_params_container/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ApmRuleParamsContainer(props) {
  const {
    fields,
    groupAlertsBy,
    kqlFilter,
    setRuleParams,
    defaultParams,
    chartPreview,
    minimumWindowSize
  } = props;
  const params = {
    ...defaultParams
  };
  const showMinimumWindowSizeWarning = useShowMinimumWindowSize({
    windowSize: params.windowSize,
    windowUnit: params.windowUnit,
    minimumWindowSize
  });
  (0, _react.useEffect)(() => {
    // we only want to run this on mount to set default values
    Object.keys(params).forEach(key => {
      setRuleParams(key, params[key]);
    });

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showMinimumWindowSizeWarning && minimumWindowSize && /*#__PURE__*/_react.default.createElement(MinimumWindowSizeWarning, {
    minimumWindowSize: minimumWindowSize,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }), kqlFilter, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "l",
    direction: "row",
    columns: 2,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, fields.map((field, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: index,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, field))), chartPreview, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), groupAlertsBy);
}
function MinimumWindowSizeWarning({
  minimumWindowSize
}) {
  const description = _i18n.i18n.translate('xpack.apm.alertTypes.minimumWindowSize.description', {
    defaultMessage: 'The recommended minimum value is {sizeValue} {sizeUnit}. This is to ensure that the alert has enough data to evaluate. If you choose a value that is too low, the alert may not fire as expected.',
    values: {
      sizeValue: minimumWindowSize.value,
      sizeUnit: (0, _public.getTimeUnitLabel)(minimumWindowSize.unit)
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: `Please increase "For the last" to at least ${minimumWindowSize.value} ${(0, _public.getTimeUnitLabel)(minimumWindowSize.unit)}`,
    color: "warning",
    iconType: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, description));
}
function useShowMinimumWindowSize({
  windowSize,
  windowUnit,
  minimumWindowSize
}) {
  const [showMinimumWindowSizeWarning, setShowMinimumWindowSizeWarning] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (windowSize === undefined || minimumWindowSize === undefined) {
      return;
    }
    const currentWindowSize = _moment.default.duration(windowSize, windowUnit).asMilliseconds();
    const minimumWindowSizeAsMillis = _moment.default.duration(minimumWindowSize.value, minimumWindowSize.unit).asMilliseconds();
    const shouldShow = currentWindowSize < minimumWindowSizeAsMillis;
    setShowMinimumWindowSizeWarning(shouldShow);
  }, [windowSize, windowUnit, minimumWindowSize]);
  return showMinimumWindowSizeWarning;
}