"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDetailsAppSection = AlertDetailsAppSection;
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _alertingComparators = require("@kbn/alerting-comparators");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-plugin/public");
var _public3 = require("@kbn/observability-shared-plugin/public");
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _apm = require("../../../../../common/es_fields/apm");
var _chart_pointer_event_context = require("../../../../context/chart_pointer_event/chart_pointer_event_context");
var _time_range_metadata_context = require("../../../../context/time_range_metadata/time_range_metadata_context");
var _get_comparison_chart_theme = require("../../../shared/time_comparison/get_comparison_chart_theme");
var _failed_transaction_chart = _interopRequireDefault(require("./failed_transaction_chart"));
var _helpers = require("./helpers");
var _latency_chart = _interopRequireDefault(require("./latency_chart"));
var _throughput_chart = _interopRequireDefault(require("./throughput_chart"));
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/ui_components/alert_details_app_section/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AlertDetailsAppSection({
  rule,
  alert,
  timeZone
}) {
  const {
    services
  } = (0, _public.useKibana)();
  (0, _create_call_apm_api.createCallApmApi)(services);
  const alertRuleTypeId = alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID];
  const alertEvaluationValue = alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE];
  const alertEvaluationThreshold = alert.fields[_ruleDataUtils.ALERT_EVALUATION_THRESHOLD];
  const environment = alert.fields[_apm.SERVICE_ENVIRONMENT];
  const serviceName = String(alert.fields[_apm.SERVICE_NAME]);
  const transactionName = alert.fields[_apm.TRANSACTION_NAME];
  const transactionType = alert.fields[_apm.TRANSACTION_TYPE];
  const params = rule.params;
  const latencyAggregationType = (0, _helpers.getAggsTypeFromRule)(params.aggregationType);
  const timeRange = (0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(alert.fields[_ruleDataUtils.ALERT_START], alert.fields[_ruleDataUtils.ALERT_END]);
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const chartThemes = (0, _public3.useChartThemes)();
  const thresholdComponent = alertEvaluationValue && alertEvaluationThreshold ? /*#__PURE__*/_react.default.createElement(_public2.Threshold, {
    chartProps: chartThemes,
    id: "latency-threshold",
    threshold: [alertEvaluationThreshold],
    value: alertEvaluationValue,
    valueFormatter: d => String((0, _public2.formatAlertEvaluationValue)(alertRuleTypeId, d)),
    title: _i18n.i18n.translate('xpack.apm.alertDetails.thresholdTitle', {
      defaultMessage: 'Threshold breached'
    }),
    comparator: _alertingComparators.COMPARATORS.GREATER_THAN,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }) : undefined;
  const {
    from,
    to
  } = timeRange;
  if (!from || !to) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.apm.alertDetails.error.toastTitle",
        defaultMessage: "An error occurred when identifying the alert time range.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 11
        }
      }),
      color: "danger",
      iconType: "error",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.alertDetails.error.toastDescription",
      defaultMessage: "Unable to load the alert details page's charts. Please try to refresh the page if the alert is newly created",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_time_range_metadata_context.TimeRangeMetadataContextProvider, {
    start: from,
    end: to,
    kuery: "",
    useSpanName: false,
    uiSettings: services.uiSettings,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_latency_chart.default, {
    alert: alert,
    transactionType: transactionType,
    transactionName: transactionName,
    serviceName: serviceName,
    environment: environment,
    start: from,
    end: to,
    comparisonChartTheme: comparisonChartTheme,
    timeZone: timeZone,
    latencyAggregationType: latencyAggregationType,
    comparisonEnabled: false,
    offset: '',
    threshold: thresholdComponent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_throughput_chart.default, {
    transactionType: transactionType,
    transactionName: transactionName,
    serviceName: serviceName,
    environment: environment,
    start: from,
    end: to,
    comparisonChartTheme: comparisonChartTheme,
    comparisonEnabled: false,
    offset: '',
    timeZone: timeZone,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_failed_transaction_chart.default, {
    transactionType: transactionType,
    transactionName: transactionName,
    serviceName: serviceName,
    environment: environment,
    start: from,
    end: to,
    comparisonChartTheme: comparisonChartTheme,
    timeZone: timeZone,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }))))));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = AlertDetailsAppSection;