"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVICE_MAP_TIMEOUT_ERROR = void 0;
exports.getConnections = getConnections;
exports.getEdgeId = getEdgeId;
exports.getExitSpanNodeId = getExitSpanNodeId;
exports.getExternalConnectionNode = getExternalConnectionNode;
exports.getLegacyNodeId = getLegacyNodeId;
exports.getServiceConnectionNode = getServiceConnectionNode;
exports.isExitSpan = exports.invalidLicenseMessage = void 0;
exports.isSpanGroupingSupported = isSpanGroupingSupported;
var _i18n = require("@kbn/i18n");
var _apm = require("../es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const invalidLicenseMessage = exports.invalidLicenseMessage = _i18n.i18n.translate('xpack.apm.serviceMap.invalidLicenseMessage', {
  defaultMessage: "In order to access Service maps, you must be subscribed to an Elastic Platinum license. With it, you'll have the ability to visualize your entire application stack along with your APM data."
});
const NONGROUPED_SPANS = {
  aws: ['servicename'],
  cache: ['all'],
  db: ['all'],
  external: ['graphql', 'grpc', 'websocket'],
  messaging: ['all'],
  template: ['handlebars']
};
function isSpanGroupingSupported(type, subtype) {
  if (!type || !(type in NONGROUPED_SPANS)) {
    return true;
  }
  return !NONGROUPED_SPANS[type].some(nongroupedSubType => nongroupedSubType === 'all' || nongroupedSubType === subtype);
}
function getConnections(paths) {
  if (!paths) {
    return [];
  }
  const connectionsById = new Set();
  const connections = [];
  paths.forEach(path => {
    for (let i = 1; i < path.length; i++) {
      const sourceNode = 'id' in path[i - 1] ? path[i - 1] : {
        ...path[i - 1],
        id: getLegacyNodeId(path[i - 1])
      };
      const destinationNode = 'id' in path[i] ? path[i] : {
        ...path[i],
        id: getLegacyNodeId(path[i])
      };
      const connectionId = getEdgeId(sourceNode.id, destinationNode.id);
      if (!connectionsById.has(connectionId)) {
        connectionsById.add(connectionId);
        connections.push({
          source: sourceNode,
          destination: destinationNode
        });
      }
    }
  });
  return connections;
}
const isExitSpan = node => {
  return !!node[_apm.SPAN_DESTINATION_SERVICE_RESOURCE];
};

// backward compatibility with scrited_metric versions
exports.isExitSpan = isExitSpan;
function getLegacyNodeId(node) {
  if (isExitSpan(node)) {
    return getExitSpanNodeId(node);
  }
  return `${node[_apm.SERVICE_NAME]}`;
}
function getServiceConnectionNode(event) {
  return {
    id: event.serviceName,
    [_apm.SERVICE_NAME]: event.serviceName,
    [_apm.SERVICE_ENVIRONMENT]: event.serviceEnvironment || null,
    [_apm.AGENT_NAME]: event.agentName
  };
}
function getExternalConnectionNode(event) {
  return {
    id: `>${event.serviceName}|${event.spanDestinationServiceResource}`,
    [_apm.SPAN_DESTINATION_SERVICE_RESOURCE]: event.spanDestinationServiceResource,
    [_apm.SPAN_TYPE]: event.spanType,
    [_apm.SPAN_SUBTYPE]: event.spanSubtype
  };
}
function getEdgeId(sourceId, destinationId) {
  return `${sourceId}~${destinationId}`;
}
function getExitSpanNodeId(span) {
  return `>${span[_apm.SPAN_DESTINATION_SERVICE_RESOURCE]}`;
}
const SERVICE_MAP_TIMEOUT_ERROR = exports.SERVICE_MAP_TIMEOUT_ERROR = 'ServiceMapTimeoutError';