"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.piiFilter = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const piiFilter = payload => {
  try {
    // if user context is defined, apply the pii filter
    if ((0, _lodash.has)(payload.context, 'user')) {
      // if the user context has loopable properties, redact the values
      if (payload.context.user != null && (0, _lodash.isPlainObject)(payload.context.user)) {
        const userContextKeys = Object.keys(payload.context.user);
        for (const key of userContextKeys) {
          payload.context.user[key] = '[REDACTED]';
        }
      } else {
        // Replace with a known invalid object to avoid APM trace discards
        payload.context.user = {
          id: '[INVALID]'
        };
      }
    }
  } catch (error) {
    // If there's an error for any reason in the context access, override the whole user context.
    Object.assign(payload.context, {
      user: {
        id: '[INVALID]'
      }
    });
  }
  return payload;
};
exports.piiFilter = piiFilter;