"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.schemaUnknownArray = exports.schemaUnknown = exports.schemaStringOrNumberArray = exports.schemaStringOrNumber = exports.schemaStringArray = exports.schemaString = exports.schemaNumberArray = exports.schemaNumber = exports.schemaGeoPointArray = exports.schemaGeoPoint = exports.schemaDateRangeArray = exports.schemaDateRange = exports.schemaDateArray = exports.schemaDate = exports.schemaBooleanArray = exports.schemaBoolean = exports.IsoDateString = exports.EcsSchema = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// ---------------------------------- WARNING ----------------------------------
// this file was generated, and should not be edited by hand
// ---------------------------------- WARNING ----------------------------------

const ISO_DATE_PATTERN = /^d{4}-d{2}-d{2}Td{2}:d{2}:d{2}.d{3}Z$/;
const IsoDateString = exports.IsoDateString = new rt.Type('IsoDateString', rt.string.is, (input, context) => {
  if (typeof input === 'string' && ISO_DATE_PATTERN.test(input)) {
    return rt.success(input);
  } else {
    return rt.failure(input, context);
  }
}, rt.identity);
const schemaUnknown = exports.schemaUnknown = rt.unknown;
const schemaUnknownArray = exports.schemaUnknownArray = rt.array(rt.unknown);
const schemaString = exports.schemaString = rt.string;
const schemaStringArray = exports.schemaStringArray = rt.array(schemaString);
const schemaNumber = exports.schemaNumber = rt.number;
const schemaNumberArray = exports.schemaNumberArray = rt.array(schemaNumber);
const schemaDate = exports.schemaDate = rt.union([IsoDateString, schemaNumber]);
const schemaDateArray = exports.schemaDateArray = rt.array(schemaDate);
const schemaDateRange = exports.schemaDateRange = rt.partial({
  gte: schemaDate,
  lte: schemaDate
});
const schemaDateRangeArray = exports.schemaDateRangeArray = rt.array(schemaDateRange);
const schemaStringOrNumber = exports.schemaStringOrNumber = rt.union([schemaString, schemaNumber]);
const schemaStringOrNumberArray = exports.schemaStringOrNumberArray = rt.array(schemaStringOrNumber);
const schemaBoolean = exports.schemaBoolean = rt.boolean;
const schemaBooleanArray = exports.schemaBooleanArray = rt.array(schemaBoolean);
const schemaGeoPointCoords = rt.type({
  type: schemaString,
  coordinates: schemaNumberArray
});
const schemaGeoPointString = schemaString;
const schemaGeoPointLatLon = rt.type({
  lat: schemaNumber,
  lon: schemaNumber
});
const schemaGeoPointLocation = rt.type({
  location: schemaNumberArray
});
const schemaGeoPointLocationString = rt.type({
  location: schemaString
});
const schemaGeoPoint = exports.schemaGeoPoint = rt.union([schemaGeoPointCoords, schemaGeoPointString, schemaGeoPointLatLon, schemaGeoPointLocation, schemaGeoPointLocationString]);
const schemaGeoPointArray = exports.schemaGeoPointArray = rt.array(schemaGeoPoint);
// prettier-ignore
const EcsRequired = rt.type({
  '@timestamp': schemaDate,
  'ecs.version': schemaString
});
// prettier-ignore
const EcsOptional = rt.partial({
  'agent.build.original': schemaString,
  'agent.ephemeral_id': schemaString,
  'agent.id': schemaString,
  'agent.name': schemaString,
  'agent.type': schemaString,
  'agent.version': schemaString,
  'client.address': schemaString,
  'client.as.number': schemaStringOrNumber,
  'client.as.organization.name': schemaString,
  'client.bytes': schemaStringOrNumber,
  'client.domain': schemaString,
  'client.geo.city_name': schemaString,
  'client.geo.continent_code': schemaString,
  'client.geo.continent_name': schemaString,
  'client.geo.country_iso_code': schemaString,
  'client.geo.country_name': schemaString,
  'client.geo.location': schemaGeoPoint,
  'client.geo.name': schemaString,
  'client.geo.postal_code': schemaString,
  'client.geo.region_iso_code': schemaString,
  'client.geo.region_name': schemaString,
  'client.geo.timezone': schemaString,
  'client.ip': schemaString,
  'client.mac': schemaString,
  'client.nat.ip': schemaString,
  'client.nat.port': schemaStringOrNumber,
  'client.packets': schemaStringOrNumber,
  'client.port': schemaStringOrNumber,
  'client.registered_domain': schemaString,
  'client.subdomain': schemaString,
  'client.top_level_domain': schemaString,
  'client.user.domain': schemaString,
  'client.user.email': schemaString,
  'client.user.full_name': schemaString,
  'client.user.group.domain': schemaString,
  'client.user.group.id': schemaString,
  'client.user.group.name': schemaString,
  'client.user.hash': schemaString,
  'client.user.id': schemaString,
  'client.user.name': schemaString,
  'client.user.roles': schemaStringArray,
  'cloud.account.id': schemaString,
  'cloud.account.name': schemaString,
  'cloud.availability_zone': schemaString,
  'cloud.instance.id': schemaString,
  'cloud.instance.name': schemaString,
  'cloud.machine.type': schemaString,
  'cloud.origin.account.id': schemaString,
  'cloud.origin.account.name': schemaString,
  'cloud.origin.availability_zone': schemaString,
  'cloud.origin.instance.id': schemaString,
  'cloud.origin.instance.name': schemaString,
  'cloud.origin.machine.type': schemaString,
  'cloud.origin.project.id': schemaString,
  'cloud.origin.project.name': schemaString,
  'cloud.origin.provider': schemaString,
  'cloud.origin.region': schemaString,
  'cloud.origin.service.name': schemaString,
  'cloud.project.id': schemaString,
  'cloud.project.name': schemaString,
  'cloud.provider': schemaString,
  'cloud.region': schemaString,
  'cloud.service.name': schemaString,
  'cloud.target.account.id': schemaString,
  'cloud.target.account.name': schemaString,
  'cloud.target.availability_zone': schemaString,
  'cloud.target.instance.id': schemaString,
  'cloud.target.instance.name': schemaString,
  'cloud.target.machine.type': schemaString,
  'cloud.target.project.id': schemaString,
  'cloud.target.project.name': schemaString,
  'cloud.target.provider': schemaString,
  'cloud.target.region': schemaString,
  'cloud.target.service.name': schemaString,
  'container.cpu.usage': schemaStringOrNumber,
  'container.disk.read.bytes': schemaStringOrNumber,
  'container.disk.write.bytes': schemaStringOrNumber,
  'container.id': schemaString,
  'container.image.hash.all': schemaStringArray,
  'container.image.name': schemaString,
  'container.image.tag': schemaStringArray,
  'container.labels': schemaUnknown,
  'container.memory.usage': schemaStringOrNumber,
  'container.name': schemaString,
  'container.network.egress.bytes': schemaStringOrNumber,
  'container.network.ingress.bytes': schemaStringOrNumber,
  'container.runtime': schemaString,
  'container.security_context.privileged': schemaBoolean,
  'destination.address': schemaString,
  'destination.as.number': schemaStringOrNumber,
  'destination.as.organization.name': schemaString,
  'destination.bytes': schemaStringOrNumber,
  'destination.domain': schemaString,
  'destination.geo.city_name': schemaString,
  'destination.geo.continent_code': schemaString,
  'destination.geo.continent_name': schemaString,
  'destination.geo.country_iso_code': schemaString,
  'destination.geo.country_name': schemaString,
  'destination.geo.location': schemaGeoPoint,
  'destination.geo.name': schemaString,
  'destination.geo.postal_code': schemaString,
  'destination.geo.region_iso_code': schemaString,
  'destination.geo.region_name': schemaString,
  'destination.geo.timezone': schemaString,
  'destination.ip': schemaString,
  'destination.mac': schemaString,
  'destination.nat.ip': schemaString,
  'destination.nat.port': schemaStringOrNumber,
  'destination.packets': schemaStringOrNumber,
  'destination.port': schemaStringOrNumber,
  'destination.registered_domain': schemaString,
  'destination.subdomain': schemaString,
  'destination.top_level_domain': schemaString,
  'destination.user.domain': schemaString,
  'destination.user.email': schemaString,
  'destination.user.full_name': schemaString,
  'destination.user.group.domain': schemaString,
  'destination.user.group.id': schemaString,
  'destination.user.group.name': schemaString,
  'destination.user.hash': schemaString,
  'destination.user.id': schemaString,
  'destination.user.name': schemaString,
  'destination.user.roles': schemaStringArray,
  'device.id': schemaString,
  'device.manufacturer': schemaString,
  'device.model.identifier': schemaString,
  'device.model.name': schemaString,
  'device.serial_number': schemaString,
  'dll.code_signature.digest_algorithm': schemaString,
  'dll.code_signature.exists': schemaBoolean,
  'dll.code_signature.flags': schemaString,
  'dll.code_signature.signing_id': schemaString,
  'dll.code_signature.status': schemaString,
  'dll.code_signature.subject_name': schemaString,
  'dll.code_signature.team_id': schemaString,
  'dll.code_signature.timestamp': schemaDate,
  'dll.code_signature.trusted': schemaBoolean,
  'dll.code_signature.valid': schemaBoolean,
  'dll.hash.cdhash': schemaString,
  'dll.hash.md5': schemaString,
  'dll.hash.sha1': schemaString,
  'dll.hash.sha256': schemaString,
  'dll.hash.sha384': schemaString,
  'dll.hash.sha512': schemaString,
  'dll.hash.ssdeep': schemaString,
  'dll.hash.tlsh': schemaString,
  'dll.name': schemaString,
  'dll.origin_referrer_url': schemaString,
  'dll.origin_url': schemaString,
  'dll.path': schemaString,
  'dll.pe.architecture': schemaString,
  'dll.pe.company': schemaString,
  'dll.pe.description': schemaString,
  'dll.pe.file_version': schemaString,
  'dll.pe.go_import_hash': schemaString,
  'dll.pe.go_imports': schemaUnknown,
  'dll.pe.go_imports_names_entropy': schemaStringOrNumber,
  'dll.pe.go_imports_names_var_entropy': schemaStringOrNumber,
  'dll.pe.go_stripped': schemaBoolean,
  'dll.pe.imphash': schemaString,
  'dll.pe.import_hash': schemaString,
  'dll.pe.imports': schemaUnknownArray,
  'dll.pe.imports_names_entropy': schemaStringOrNumber,
  'dll.pe.imports_names_var_entropy': schemaStringOrNumber,
  'dll.pe.original_file_name': schemaString,
  'dll.pe.pehash': schemaString,
  'dll.pe.product': schemaString,
  'dll.pe.sections': rt.array(rt.partial({
    entropy: schemaStringOrNumber,
    name: schemaString,
    physical_size: schemaStringOrNumber,
    var_entropy: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'dns.answers': rt.array(rt.partial({
    class: schemaString,
    data: schemaString,
    name: schemaString,
    ttl: schemaStringOrNumber,
    type: schemaString
  })),
  'dns.header_flags': schemaStringArray,
  'dns.id': schemaString,
  'dns.op_code': schemaString,
  'dns.question.class': schemaString,
  'dns.question.name': schemaString,
  'dns.question.registered_domain': schemaString,
  'dns.question.subdomain': schemaString,
  'dns.question.top_level_domain': schemaString,
  'dns.question.type': schemaString,
  'dns.resolved_ip': schemaStringArray,
  'dns.response_code': schemaString,
  'dns.type': schemaString,
  'email.attachments': rt.array(rt.partial({
    'file.extension': schemaString,
    'file.hash.cdhash': schemaString,
    'file.hash.md5': schemaString,
    'file.hash.sha1': schemaString,
    'file.hash.sha256': schemaString,
    'file.hash.sha384': schemaString,
    'file.hash.sha512': schemaString,
    'file.hash.ssdeep': schemaString,
    'file.hash.tlsh': schemaString,
    'file.mime_type': schemaString,
    'file.name': schemaString,
    'file.size': schemaStringOrNumber
  })),
  'email.bcc.address': schemaStringArray,
  'email.cc.address': schemaStringArray,
  'email.content_type': schemaString,
  'email.delivery_timestamp': schemaDate,
  'email.direction': schemaString,
  'email.from.address': schemaStringArray,
  'email.local_id': schemaString,
  'email.message_id': schemaString,
  'email.origination_timestamp': schemaDate,
  'email.reply_to.address': schemaStringArray,
  'email.sender.address': schemaString,
  'email.subject': schemaString,
  'email.to.address': schemaStringArray,
  'email.x_mailer': schemaString,
  'error.code': schemaString,
  'error.id': schemaString,
  'error.message': schemaString,
  'error.stack_trace': schemaString,
  'error.type': schemaString,
  'event.action': schemaString,
  'event.agent_id_status': schemaString,
  'event.category': schemaStringArray,
  'event.code': schemaString,
  'event.created': schemaDate,
  'event.dataset': schemaString,
  'event.duration': schemaStringOrNumber,
  'event.end': schemaDate,
  'event.hash': schemaString,
  'event.id': schemaString,
  'event.ingested': schemaDate,
  'event.kind': schemaString,
  'event.module': schemaString,
  'event.original': schemaString,
  'event.outcome': schemaString,
  'event.provider': schemaString,
  'event.reason': schemaString,
  'event.reference': schemaString,
  'event.risk_score': schemaNumber,
  'event.risk_score_norm': schemaNumber,
  'event.sequence': schemaStringOrNumber,
  'event.severity': schemaStringOrNumber,
  'event.start': schemaDate,
  'event.timezone': schemaString,
  'event.type': schemaStringArray,
  'event.url': schemaString,
  'faas.coldstart': schemaBoolean,
  'faas.execution': schemaString,
  'faas.id': schemaString,
  'faas.name': schemaString,
  'faas.version': schemaString,
  'file.accessed': schemaDate,
  'file.attributes': schemaStringArray,
  'file.code_signature.digest_algorithm': schemaString,
  'file.code_signature.exists': schemaBoolean,
  'file.code_signature.flags': schemaString,
  'file.code_signature.signing_id': schemaString,
  'file.code_signature.status': schemaString,
  'file.code_signature.subject_name': schemaString,
  'file.code_signature.team_id': schemaString,
  'file.code_signature.timestamp': schemaDate,
  'file.code_signature.trusted': schemaBoolean,
  'file.code_signature.valid': schemaBoolean,
  'file.created': schemaDate,
  'file.ctime': schemaDate,
  'file.device': schemaString,
  'file.directory': schemaString,
  'file.drive_letter': schemaString,
  'file.elf.architecture': schemaString,
  'file.elf.byte_order': schemaString,
  'file.elf.cpu_type': schemaString,
  'file.elf.creation_date': schemaDate,
  'file.elf.exports': schemaUnknownArray,
  'file.elf.go_import_hash': schemaString,
  'file.elf.go_imports': schemaUnknown,
  'file.elf.go_imports_names_entropy': schemaStringOrNumber,
  'file.elf.go_imports_names_var_entropy': schemaStringOrNumber,
  'file.elf.go_stripped': schemaBoolean,
  'file.elf.header.abi_version': schemaString,
  'file.elf.header.class': schemaString,
  'file.elf.header.data': schemaString,
  'file.elf.header.entrypoint': schemaStringOrNumber,
  'file.elf.header.object_version': schemaString,
  'file.elf.header.os_abi': schemaString,
  'file.elf.header.type': schemaString,
  'file.elf.header.version': schemaString,
  'file.elf.import_hash': schemaString,
  'file.elf.imports': schemaUnknownArray,
  'file.elf.imports_names_entropy': schemaStringOrNumber,
  'file.elf.imports_names_var_entropy': schemaStringOrNumber,
  'file.elf.sections': rt.array(rt.partial({
    chi2: schemaStringOrNumber,
    entropy: schemaStringOrNumber,
    flags: schemaString,
    name: schemaString,
    physical_offset: schemaString,
    physical_size: schemaStringOrNumber,
    type: schemaString,
    var_entropy: schemaStringOrNumber,
    virtual_address: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'file.elf.segments': rt.array(rt.partial({
    sections: schemaString,
    type: schemaString
  })),
  'file.elf.shared_libraries': schemaStringArray,
  'file.elf.telfhash': schemaString,
  'file.extension': schemaString,
  'file.fork_name': schemaString,
  'file.gid': schemaString,
  'file.group': schemaString,
  'file.hash.cdhash': schemaString,
  'file.hash.md5': schemaString,
  'file.hash.sha1': schemaString,
  'file.hash.sha256': schemaString,
  'file.hash.sha384': schemaString,
  'file.hash.sha512': schemaString,
  'file.hash.ssdeep': schemaString,
  'file.hash.tlsh': schemaString,
  'file.inode': schemaString,
  'file.macho.go_import_hash': schemaString,
  'file.macho.go_imports': schemaUnknown,
  'file.macho.go_imports_names_entropy': schemaStringOrNumber,
  'file.macho.go_imports_names_var_entropy': schemaStringOrNumber,
  'file.macho.go_stripped': schemaBoolean,
  'file.macho.import_hash': schemaString,
  'file.macho.imports': schemaUnknownArray,
  'file.macho.imports_names_entropy': schemaStringOrNumber,
  'file.macho.imports_names_var_entropy': schemaStringOrNumber,
  'file.macho.sections': rt.array(rt.partial({
    entropy: schemaStringOrNumber,
    name: schemaString,
    physical_size: schemaStringOrNumber,
    var_entropy: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'file.macho.symhash': schemaString,
  'file.mime_type': schemaString,
  'file.mode': schemaString,
  'file.mtime': schemaDate,
  'file.name': schemaString,
  'file.origin_referrer_url': schemaString,
  'file.origin_url': schemaString,
  'file.owner': schemaString,
  'file.path': schemaString,
  'file.pe.architecture': schemaString,
  'file.pe.company': schemaString,
  'file.pe.description': schemaString,
  'file.pe.file_version': schemaString,
  'file.pe.go_import_hash': schemaString,
  'file.pe.go_imports': schemaUnknown,
  'file.pe.go_imports_names_entropy': schemaStringOrNumber,
  'file.pe.go_imports_names_var_entropy': schemaStringOrNumber,
  'file.pe.go_stripped': schemaBoolean,
  'file.pe.imphash': schemaString,
  'file.pe.import_hash': schemaString,
  'file.pe.imports': schemaUnknownArray,
  'file.pe.imports_names_entropy': schemaStringOrNumber,
  'file.pe.imports_names_var_entropy': schemaStringOrNumber,
  'file.pe.original_file_name': schemaString,
  'file.pe.pehash': schemaString,
  'file.pe.product': schemaString,
  'file.pe.sections': rt.array(rt.partial({
    entropy: schemaStringOrNumber,
    name: schemaString,
    physical_size: schemaStringOrNumber,
    var_entropy: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'file.size': schemaStringOrNumber,
  'file.target_path': schemaString,
  'file.type': schemaString,
  'file.uid': schemaString,
  'file.x509.alternative_names': schemaStringArray,
  'file.x509.issuer.common_name': schemaStringArray,
  'file.x509.issuer.country': schemaStringArray,
  'file.x509.issuer.distinguished_name': schemaString,
  'file.x509.issuer.locality': schemaStringArray,
  'file.x509.issuer.organization': schemaStringArray,
  'file.x509.issuer.organizational_unit': schemaStringArray,
  'file.x509.issuer.state_or_province': schemaStringArray,
  'file.x509.not_after': schemaDate,
  'file.x509.not_before': schemaDate,
  'file.x509.public_key_algorithm': schemaString,
  'file.x509.public_key_curve': schemaString,
  'file.x509.public_key_exponent': schemaStringOrNumber,
  'file.x509.public_key_size': schemaStringOrNumber,
  'file.x509.serial_number': schemaString,
  'file.x509.signature_algorithm': schemaString,
  'file.x509.subject.common_name': schemaStringArray,
  'file.x509.subject.country': schemaStringArray,
  'file.x509.subject.distinguished_name': schemaString,
  'file.x509.subject.locality': schemaStringArray,
  'file.x509.subject.organization': schemaStringArray,
  'file.x509.subject.organizational_unit': schemaStringArray,
  'file.x509.subject.state_or_province': schemaStringArray,
  'file.x509.version_number': schemaString,
  'group.domain': schemaString,
  'group.id': schemaString,
  'group.name': schemaString,
  'host.architecture': schemaString,
  'host.boot.id': schemaString,
  'host.cpu.usage': schemaStringOrNumber,
  'host.disk.read.bytes': schemaStringOrNumber,
  'host.disk.write.bytes': schemaStringOrNumber,
  'host.domain': schemaString,
  'host.geo.city_name': schemaString,
  'host.geo.continent_code': schemaString,
  'host.geo.continent_name': schemaString,
  'host.geo.country_iso_code': schemaString,
  'host.geo.country_name': schemaString,
  'host.geo.location': schemaGeoPoint,
  'host.geo.name': schemaString,
  'host.geo.postal_code': schemaString,
  'host.geo.region_iso_code': schemaString,
  'host.geo.region_name': schemaString,
  'host.geo.timezone': schemaString,
  'host.hostname': schemaString,
  'host.id': schemaString,
  'host.ip': schemaStringArray,
  'host.mac': schemaStringArray,
  'host.name': schemaString,
  'host.network.egress.bytes': schemaStringOrNumber,
  'host.network.egress.packets': schemaStringOrNumber,
  'host.network.ingress.bytes': schemaStringOrNumber,
  'host.network.ingress.packets': schemaStringOrNumber,
  'host.os.family': schemaString,
  'host.os.full': schemaString,
  'host.os.kernel': schemaString,
  'host.os.name': schemaString,
  'host.os.platform': schemaString,
  'host.os.type': schemaString,
  'host.os.version': schemaString,
  'host.pid_ns_ino': schemaString,
  'host.risk.calculated_level': schemaString,
  'host.risk.calculated_score': schemaNumber,
  'host.risk.calculated_score_norm': schemaNumber,
  'host.risk.static_level': schemaString,
  'host.risk.static_score': schemaNumber,
  'host.risk.static_score_norm': schemaNumber,
  'host.type': schemaString,
  'host.uptime': schemaStringOrNumber,
  'http.request.body.bytes': schemaStringOrNumber,
  'http.request.body.content': schemaString,
  'http.request.bytes': schemaStringOrNumber,
  'http.request.id': schemaString,
  'http.request.method': schemaString,
  'http.request.mime_type': schemaString,
  'http.request.referrer': schemaString,
  'http.response.body.bytes': schemaStringOrNumber,
  'http.response.body.content': schemaString,
  'http.response.bytes': schemaStringOrNumber,
  'http.response.mime_type': schemaString,
  'http.response.status_code': schemaStringOrNumber,
  'http.version': schemaString,
  labels: schemaUnknown,
  'log.file.path': schemaString,
  'log.level': schemaString,
  'log.logger': schemaString,
  'log.origin.file.line': schemaStringOrNumber,
  'log.origin.file.name': schemaString,
  'log.origin.function': schemaString,
  'log.syslog': schemaUnknown,
  message: schemaString,
  'network.application': schemaString,
  'network.bytes': schemaStringOrNumber,
  'network.community_id': schemaString,
  'network.direction': schemaString,
  'network.forwarded_ip': schemaString,
  'network.iana_number': schemaString,
  'network.inner': schemaUnknown,
  'network.name': schemaString,
  'network.packets': schemaStringOrNumber,
  'network.protocol': schemaString,
  'network.transport': schemaString,
  'network.type': schemaString,
  'network.vlan.id': schemaString,
  'network.vlan.name': schemaString,
  'observer.egress': schemaUnknown,
  'observer.geo.city_name': schemaString,
  'observer.geo.continent_code': schemaString,
  'observer.geo.continent_name': schemaString,
  'observer.geo.country_iso_code': schemaString,
  'observer.geo.country_name': schemaString,
  'observer.geo.location': schemaGeoPoint,
  'observer.geo.name': schemaString,
  'observer.geo.postal_code': schemaString,
  'observer.geo.region_iso_code': schemaString,
  'observer.geo.region_name': schemaString,
  'observer.geo.timezone': schemaString,
  'observer.hostname': schemaString,
  'observer.ingress': schemaUnknown,
  'observer.ip': schemaStringArray,
  'observer.mac': schemaStringArray,
  'observer.name': schemaString,
  'observer.os.family': schemaString,
  'observer.os.full': schemaString,
  'observer.os.kernel': schemaString,
  'observer.os.name': schemaString,
  'observer.os.platform': schemaString,
  'observer.os.type': schemaString,
  'observer.os.version': schemaString,
  'observer.product': schemaString,
  'observer.serial_number': schemaString,
  'observer.type': schemaString,
  'observer.vendor': schemaString,
  'observer.version': schemaString,
  'orchestrator.api_version': schemaString,
  'orchestrator.cluster.id': schemaString,
  'orchestrator.cluster.name': schemaString,
  'orchestrator.cluster.url': schemaString,
  'orchestrator.cluster.version': schemaString,
  'orchestrator.namespace': schemaString,
  'orchestrator.organization': schemaString,
  'orchestrator.resource.annotation': schemaStringArray,
  'orchestrator.resource.id': schemaString,
  'orchestrator.resource.ip': schemaStringArray,
  'orchestrator.resource.label': schemaStringArray,
  'orchestrator.resource.name': schemaString,
  'orchestrator.resource.parent.type': schemaString,
  'orchestrator.resource.type': schemaString,
  'orchestrator.type': schemaString,
  'organization.id': schemaString,
  'organization.name': schemaString,
  'package.architecture': schemaString,
  'package.build_version': schemaString,
  'package.checksum': schemaString,
  'package.description': schemaString,
  'package.install_scope': schemaString,
  'package.installed': schemaDate,
  'package.license': schemaString,
  'package.name': schemaString,
  'package.path': schemaString,
  'package.reference': schemaString,
  'package.size': schemaStringOrNumber,
  'package.type': schemaString,
  'package.version': schemaString,
  'process.args': schemaStringArray,
  'process.args_count': schemaStringOrNumber,
  'process.code_signature.digest_algorithm': schemaString,
  'process.code_signature.exists': schemaBoolean,
  'process.code_signature.flags': schemaString,
  'process.code_signature.signing_id': schemaString,
  'process.code_signature.status': schemaString,
  'process.code_signature.subject_name': schemaString,
  'process.code_signature.team_id': schemaString,
  'process.code_signature.timestamp': schemaDate,
  'process.code_signature.trusted': schemaBoolean,
  'process.code_signature.valid': schemaBoolean,
  'process.command_line': schemaString,
  'process.elf.architecture': schemaString,
  'process.elf.byte_order': schemaString,
  'process.elf.cpu_type': schemaString,
  'process.elf.creation_date': schemaDate,
  'process.elf.exports': schemaUnknownArray,
  'process.elf.go_import_hash': schemaString,
  'process.elf.go_imports': schemaUnknown,
  'process.elf.go_imports_names_entropy': schemaStringOrNumber,
  'process.elf.go_imports_names_var_entropy': schemaStringOrNumber,
  'process.elf.go_stripped': schemaBoolean,
  'process.elf.header.abi_version': schemaString,
  'process.elf.header.class': schemaString,
  'process.elf.header.data': schemaString,
  'process.elf.header.entrypoint': schemaStringOrNumber,
  'process.elf.header.object_version': schemaString,
  'process.elf.header.os_abi': schemaString,
  'process.elf.header.type': schemaString,
  'process.elf.header.version': schemaString,
  'process.elf.import_hash': schemaString,
  'process.elf.imports': schemaUnknownArray,
  'process.elf.imports_names_entropy': schemaStringOrNumber,
  'process.elf.imports_names_var_entropy': schemaStringOrNumber,
  'process.elf.sections': rt.array(rt.partial({
    chi2: schemaStringOrNumber,
    entropy: schemaStringOrNumber,
    flags: schemaString,
    name: schemaString,
    physical_offset: schemaString,
    physical_size: schemaStringOrNumber,
    type: schemaString,
    var_entropy: schemaStringOrNumber,
    virtual_address: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'process.elf.segments': rt.array(rt.partial({
    sections: schemaString,
    type: schemaString
  })),
  'process.elf.shared_libraries': schemaStringArray,
  'process.elf.telfhash': schemaString,
  'process.end': schemaDate,
  'process.entity_id': schemaString,
  'process.entry_leader.args': schemaStringArray,
  'process.entry_leader.args_count': schemaStringOrNumber,
  'process.entry_leader.attested_groups.name': schemaString,
  'process.entry_leader.attested_user.id': schemaString,
  'process.entry_leader.attested_user.name': schemaString,
  'process.entry_leader.command_line': schemaString,
  'process.entry_leader.entity_id': schemaString,
  'process.entry_leader.entry_meta.source.ip': schemaString,
  'process.entry_leader.entry_meta.type': schemaString,
  'process.entry_leader.executable': schemaString,
  'process.entry_leader.group.id': schemaString,
  'process.entry_leader.group.name': schemaString,
  'process.entry_leader.interactive': schemaBoolean,
  'process.entry_leader.name': schemaString,
  'process.entry_leader.parent.entity_id': schemaString,
  'process.entry_leader.parent.pid': schemaStringOrNumber,
  'process.entry_leader.parent.session_leader.entity_id': schemaString,
  'process.entry_leader.parent.session_leader.pid': schemaStringOrNumber,
  'process.entry_leader.parent.session_leader.start': schemaDate,
  'process.entry_leader.parent.session_leader.vpid': schemaStringOrNumber,
  'process.entry_leader.parent.start': schemaDate,
  'process.entry_leader.parent.vpid': schemaStringOrNumber,
  'process.entry_leader.pid': schemaStringOrNumber,
  'process.entry_leader.real_group.id': schemaString,
  'process.entry_leader.real_group.name': schemaString,
  'process.entry_leader.real_user.id': schemaString,
  'process.entry_leader.real_user.name': schemaString,
  'process.entry_leader.same_as_process': schemaBoolean,
  'process.entry_leader.saved_group.id': schemaString,
  'process.entry_leader.saved_group.name': schemaString,
  'process.entry_leader.saved_user.id': schemaString,
  'process.entry_leader.saved_user.name': schemaString,
  'process.entry_leader.start': schemaDate,
  'process.entry_leader.supplemental_groups.id': schemaString,
  'process.entry_leader.supplemental_groups.name': schemaString,
  'process.entry_leader.tty': schemaUnknown,
  'process.entry_leader.user.id': schemaString,
  'process.entry_leader.user.name': schemaString,
  'process.entry_leader.vpid': schemaStringOrNumber,
  'process.entry_leader.working_directory': schemaString,
  'process.env_vars': schemaStringArray,
  'process.executable': schemaString,
  'process.exit_code': schemaStringOrNumber,
  'process.group.id': schemaString,
  'process.group.name': schemaString,
  'process.group_leader.args': schemaStringArray,
  'process.group_leader.args_count': schemaStringOrNumber,
  'process.group_leader.command_line': schemaString,
  'process.group_leader.entity_id': schemaString,
  'process.group_leader.executable': schemaString,
  'process.group_leader.group.id': schemaString,
  'process.group_leader.group.name': schemaString,
  'process.group_leader.interactive': schemaBoolean,
  'process.group_leader.name': schemaString,
  'process.group_leader.pid': schemaStringOrNumber,
  'process.group_leader.real_group.id': schemaString,
  'process.group_leader.real_group.name': schemaString,
  'process.group_leader.real_user.id': schemaString,
  'process.group_leader.real_user.name': schemaString,
  'process.group_leader.same_as_process': schemaBoolean,
  'process.group_leader.saved_group.id': schemaString,
  'process.group_leader.saved_group.name': schemaString,
  'process.group_leader.saved_user.id': schemaString,
  'process.group_leader.saved_user.name': schemaString,
  'process.group_leader.start': schemaDate,
  'process.group_leader.supplemental_groups.id': schemaString,
  'process.group_leader.supplemental_groups.name': schemaString,
  'process.group_leader.tty': schemaUnknown,
  'process.group_leader.user.id': schemaString,
  'process.group_leader.user.name': schemaString,
  'process.group_leader.vpid': schemaStringOrNumber,
  'process.group_leader.working_directory': schemaString,
  'process.hash.cdhash': schemaString,
  'process.hash.md5': schemaString,
  'process.hash.sha1': schemaString,
  'process.hash.sha256': schemaString,
  'process.hash.sha384': schemaString,
  'process.hash.sha512': schemaString,
  'process.hash.ssdeep': schemaString,
  'process.hash.tlsh': schemaString,
  'process.interactive': schemaBoolean,
  'process.io': schemaUnknown,
  'process.macho.go_import_hash': schemaString,
  'process.macho.go_imports': schemaUnknown,
  'process.macho.go_imports_names_entropy': schemaStringOrNumber,
  'process.macho.go_imports_names_var_entropy': schemaStringOrNumber,
  'process.macho.go_stripped': schemaBoolean,
  'process.macho.import_hash': schemaString,
  'process.macho.imports': schemaUnknownArray,
  'process.macho.imports_names_entropy': schemaStringOrNumber,
  'process.macho.imports_names_var_entropy': schemaStringOrNumber,
  'process.macho.sections': rt.array(rt.partial({
    entropy: schemaStringOrNumber,
    name: schemaString,
    physical_size: schemaStringOrNumber,
    var_entropy: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'process.macho.symhash': schemaString,
  'process.name': schemaString,
  'process.parent.args': schemaStringArray,
  'process.parent.args_count': schemaStringOrNumber,
  'process.parent.code_signature.digest_algorithm': schemaString,
  'process.parent.code_signature.exists': schemaBoolean,
  'process.parent.code_signature.flags': schemaString,
  'process.parent.code_signature.signing_id': schemaString,
  'process.parent.code_signature.status': schemaString,
  'process.parent.code_signature.subject_name': schemaString,
  'process.parent.code_signature.team_id': schemaString,
  'process.parent.code_signature.timestamp': schemaDate,
  'process.parent.code_signature.trusted': schemaBoolean,
  'process.parent.code_signature.valid': schemaBoolean,
  'process.parent.command_line': schemaString,
  'process.parent.elf.architecture': schemaString,
  'process.parent.elf.byte_order': schemaString,
  'process.parent.elf.cpu_type': schemaString,
  'process.parent.elf.creation_date': schemaDate,
  'process.parent.elf.exports': schemaUnknownArray,
  'process.parent.elf.go_import_hash': schemaString,
  'process.parent.elf.go_imports': schemaUnknown,
  'process.parent.elf.go_imports_names_entropy': schemaStringOrNumber,
  'process.parent.elf.go_imports_names_var_entropy': schemaStringOrNumber,
  'process.parent.elf.go_stripped': schemaBoolean,
  'process.parent.elf.header.abi_version': schemaString,
  'process.parent.elf.header.class': schemaString,
  'process.parent.elf.header.data': schemaString,
  'process.parent.elf.header.entrypoint': schemaStringOrNumber,
  'process.parent.elf.header.object_version': schemaString,
  'process.parent.elf.header.os_abi': schemaString,
  'process.parent.elf.header.type': schemaString,
  'process.parent.elf.header.version': schemaString,
  'process.parent.elf.import_hash': schemaString,
  'process.parent.elf.imports': schemaUnknownArray,
  'process.parent.elf.imports_names_entropy': schemaStringOrNumber,
  'process.parent.elf.imports_names_var_entropy': schemaStringOrNumber,
  'process.parent.elf.sections': rt.array(rt.partial({
    chi2: schemaStringOrNumber,
    entropy: schemaStringOrNumber,
    flags: schemaString,
    name: schemaString,
    physical_offset: schemaString,
    physical_size: schemaStringOrNumber,
    type: schemaString,
    var_entropy: schemaStringOrNumber,
    virtual_address: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'process.parent.elf.segments': rt.array(rt.partial({
    sections: schemaString,
    type: schemaString
  })),
  'process.parent.elf.shared_libraries': schemaStringArray,
  'process.parent.elf.telfhash': schemaString,
  'process.parent.end': schemaDate,
  'process.parent.entity_id': schemaString,
  'process.parent.executable': schemaString,
  'process.parent.exit_code': schemaStringOrNumber,
  'process.parent.group.id': schemaString,
  'process.parent.group.name': schemaString,
  'process.parent.group_leader.entity_id': schemaString,
  'process.parent.group_leader.pid': schemaStringOrNumber,
  'process.parent.group_leader.start': schemaDate,
  'process.parent.group_leader.vpid': schemaStringOrNumber,
  'process.parent.hash.cdhash': schemaString,
  'process.parent.hash.md5': schemaString,
  'process.parent.hash.sha1': schemaString,
  'process.parent.hash.sha256': schemaString,
  'process.parent.hash.sha384': schemaString,
  'process.parent.hash.sha512': schemaString,
  'process.parent.hash.ssdeep': schemaString,
  'process.parent.hash.tlsh': schemaString,
  'process.parent.interactive': schemaBoolean,
  'process.parent.macho.go_import_hash': schemaString,
  'process.parent.macho.go_imports': schemaUnknown,
  'process.parent.macho.go_imports_names_entropy': schemaStringOrNumber,
  'process.parent.macho.go_imports_names_var_entropy': schemaStringOrNumber,
  'process.parent.macho.go_stripped': schemaBoolean,
  'process.parent.macho.import_hash': schemaString,
  'process.parent.macho.imports': schemaUnknownArray,
  'process.parent.macho.imports_names_entropy': schemaStringOrNumber,
  'process.parent.macho.imports_names_var_entropy': schemaStringOrNumber,
  'process.parent.macho.sections': rt.array(rt.partial({
    entropy: schemaStringOrNumber,
    name: schemaString,
    physical_size: schemaStringOrNumber,
    var_entropy: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'process.parent.macho.symhash': schemaString,
  'process.parent.name': schemaString,
  'process.parent.pe.architecture': schemaString,
  'process.parent.pe.company': schemaString,
  'process.parent.pe.description': schemaString,
  'process.parent.pe.file_version': schemaString,
  'process.parent.pe.go_import_hash': schemaString,
  'process.parent.pe.go_imports': schemaUnknown,
  'process.parent.pe.go_imports_names_entropy': schemaStringOrNumber,
  'process.parent.pe.go_imports_names_var_entropy': schemaStringOrNumber,
  'process.parent.pe.go_stripped': schemaBoolean,
  'process.parent.pe.imphash': schemaString,
  'process.parent.pe.import_hash': schemaString,
  'process.parent.pe.imports': schemaUnknownArray,
  'process.parent.pe.imports_names_entropy': schemaStringOrNumber,
  'process.parent.pe.imports_names_var_entropy': schemaStringOrNumber,
  'process.parent.pe.original_file_name': schemaString,
  'process.parent.pe.pehash': schemaString,
  'process.parent.pe.product': schemaString,
  'process.parent.pe.sections': rt.array(rt.partial({
    entropy: schemaStringOrNumber,
    name: schemaString,
    physical_size: schemaStringOrNumber,
    var_entropy: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'process.parent.pid': schemaStringOrNumber,
  'process.parent.real_group.id': schemaString,
  'process.parent.real_group.name': schemaString,
  'process.parent.real_user.id': schemaString,
  'process.parent.real_user.name': schemaString,
  'process.parent.saved_group.id': schemaString,
  'process.parent.saved_group.name': schemaString,
  'process.parent.saved_user.id': schemaString,
  'process.parent.saved_user.name': schemaString,
  'process.parent.start': schemaDate,
  'process.parent.supplemental_groups.id': schemaString,
  'process.parent.supplemental_groups.name': schemaString,
  'process.parent.thread.capabilities.effective': schemaStringArray,
  'process.parent.thread.capabilities.permitted': schemaStringArray,
  'process.parent.thread.id': schemaStringOrNumber,
  'process.parent.thread.name': schemaString,
  'process.parent.title': schemaString,
  'process.parent.tty': schemaUnknown,
  'process.parent.uptime': schemaStringOrNumber,
  'process.parent.user.id': schemaString,
  'process.parent.user.name': schemaString,
  'process.parent.vpid': schemaStringOrNumber,
  'process.parent.working_directory': schemaString,
  'process.pe.architecture': schemaString,
  'process.pe.company': schemaString,
  'process.pe.description': schemaString,
  'process.pe.file_version': schemaString,
  'process.pe.go_import_hash': schemaString,
  'process.pe.go_imports': schemaUnknown,
  'process.pe.go_imports_names_entropy': schemaStringOrNumber,
  'process.pe.go_imports_names_var_entropy': schemaStringOrNumber,
  'process.pe.go_stripped': schemaBoolean,
  'process.pe.imphash': schemaString,
  'process.pe.import_hash': schemaString,
  'process.pe.imports': schemaUnknownArray,
  'process.pe.imports_names_entropy': schemaStringOrNumber,
  'process.pe.imports_names_var_entropy': schemaStringOrNumber,
  'process.pe.original_file_name': schemaString,
  'process.pe.pehash': schemaString,
  'process.pe.product': schemaString,
  'process.pe.sections': rt.array(rt.partial({
    entropy: schemaStringOrNumber,
    name: schemaString,
    physical_size: schemaStringOrNumber,
    var_entropy: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'process.pid': schemaStringOrNumber,
  'process.previous.args': schemaStringArray,
  'process.previous.args_count': schemaStringOrNumber,
  'process.previous.executable': schemaString,
  'process.real_group.id': schemaString,
  'process.real_group.name': schemaString,
  'process.real_user.id': schemaString,
  'process.real_user.name': schemaString,
  'process.saved_group.id': schemaString,
  'process.saved_group.name': schemaString,
  'process.saved_user.id': schemaString,
  'process.saved_user.name': schemaString,
  'process.session_leader.args': schemaStringArray,
  'process.session_leader.args_count': schemaStringOrNumber,
  'process.session_leader.command_line': schemaString,
  'process.session_leader.entity_id': schemaString,
  'process.session_leader.executable': schemaString,
  'process.session_leader.group.id': schemaString,
  'process.session_leader.group.name': schemaString,
  'process.session_leader.interactive': schemaBoolean,
  'process.session_leader.name': schemaString,
  'process.session_leader.parent.entity_id': schemaString,
  'process.session_leader.parent.pid': schemaStringOrNumber,
  'process.session_leader.parent.session_leader.entity_id': schemaString,
  'process.session_leader.parent.session_leader.pid': schemaStringOrNumber,
  'process.session_leader.parent.session_leader.start': schemaDate,
  'process.session_leader.parent.session_leader.vpid': schemaStringOrNumber,
  'process.session_leader.parent.start': schemaDate,
  'process.session_leader.parent.vpid': schemaStringOrNumber,
  'process.session_leader.pid': schemaStringOrNumber,
  'process.session_leader.real_group.id': schemaString,
  'process.session_leader.real_group.name': schemaString,
  'process.session_leader.real_user.id': schemaString,
  'process.session_leader.real_user.name': schemaString,
  'process.session_leader.same_as_process': schemaBoolean,
  'process.session_leader.saved_group.id': schemaString,
  'process.session_leader.saved_group.name': schemaString,
  'process.session_leader.saved_user.id': schemaString,
  'process.session_leader.saved_user.name': schemaString,
  'process.session_leader.start': schemaDate,
  'process.session_leader.supplemental_groups.id': schemaString,
  'process.session_leader.supplemental_groups.name': schemaString,
  'process.session_leader.tty': schemaUnknown,
  'process.session_leader.user.id': schemaString,
  'process.session_leader.user.name': schemaString,
  'process.session_leader.vpid': schemaStringOrNumber,
  'process.session_leader.working_directory': schemaString,
  'process.start': schemaDate,
  'process.supplemental_groups.id': schemaString,
  'process.supplemental_groups.name': schemaString,
  'process.thread.capabilities.effective': schemaStringArray,
  'process.thread.capabilities.permitted': schemaStringArray,
  'process.thread.id': schemaStringOrNumber,
  'process.thread.name': schemaString,
  'process.title': schemaString,
  'process.tty': schemaUnknown,
  'process.uptime': schemaStringOrNumber,
  'process.user.id': schemaString,
  'process.user.name': schemaString,
  'process.vpid': schemaStringOrNumber,
  'process.working_directory': schemaString,
  'registry.data.bytes': schemaString,
  'registry.data.strings': schemaStringArray,
  'registry.data.type': schemaString,
  'registry.hive': schemaString,
  'registry.key': schemaString,
  'registry.path': schemaString,
  'registry.value': schemaString,
  'related.hash': schemaStringArray,
  'related.hosts': schemaStringArray,
  'related.ip': schemaStringArray,
  'related.user': schemaStringArray,
  'rule.author': schemaStringArray,
  'rule.category': schemaString,
  'rule.description': schemaString,
  'rule.id': schemaString,
  'rule.license': schemaString,
  'rule.name': schemaString,
  'rule.reference': schemaString,
  'rule.ruleset': schemaString,
  'rule.uuid': schemaString,
  'rule.version': schemaString,
  'server.address': schemaString,
  'server.as.number': schemaStringOrNumber,
  'server.as.organization.name': schemaString,
  'server.bytes': schemaStringOrNumber,
  'server.domain': schemaString,
  'server.geo.city_name': schemaString,
  'server.geo.continent_code': schemaString,
  'server.geo.continent_name': schemaString,
  'server.geo.country_iso_code': schemaString,
  'server.geo.country_name': schemaString,
  'server.geo.location': schemaGeoPoint,
  'server.geo.name': schemaString,
  'server.geo.postal_code': schemaString,
  'server.geo.region_iso_code': schemaString,
  'server.geo.region_name': schemaString,
  'server.geo.timezone': schemaString,
  'server.ip': schemaString,
  'server.mac': schemaString,
  'server.nat.ip': schemaString,
  'server.nat.port': schemaStringOrNumber,
  'server.packets': schemaStringOrNumber,
  'server.port': schemaStringOrNumber,
  'server.registered_domain': schemaString,
  'server.subdomain': schemaString,
  'server.top_level_domain': schemaString,
  'server.user.domain': schemaString,
  'server.user.email': schemaString,
  'server.user.full_name': schemaString,
  'server.user.group.domain': schemaString,
  'server.user.group.id': schemaString,
  'server.user.group.name': schemaString,
  'server.user.hash': schemaString,
  'server.user.id': schemaString,
  'server.user.name': schemaString,
  'server.user.roles': schemaStringArray,
  'service.address': schemaString,
  'service.environment': schemaString,
  'service.ephemeral_id': schemaString,
  'service.id': schemaString,
  'service.name': schemaString,
  'service.node.name': schemaString,
  'service.node.role': schemaString,
  'service.node.roles': schemaStringArray,
  'service.origin.address': schemaString,
  'service.origin.environment': schemaString,
  'service.origin.ephemeral_id': schemaString,
  'service.origin.id': schemaString,
  'service.origin.name': schemaString,
  'service.origin.node.name': schemaString,
  'service.origin.node.role': schemaString,
  'service.origin.node.roles': schemaStringArray,
  'service.origin.state': schemaString,
  'service.origin.type': schemaString,
  'service.origin.version': schemaString,
  'service.state': schemaString,
  'service.target.address': schemaString,
  'service.target.environment': schemaString,
  'service.target.ephemeral_id': schemaString,
  'service.target.id': schemaString,
  'service.target.name': schemaString,
  'service.target.node.name': schemaString,
  'service.target.node.role': schemaString,
  'service.target.node.roles': schemaStringArray,
  'service.target.state': schemaString,
  'service.target.type': schemaString,
  'service.target.version': schemaString,
  'service.type': schemaString,
  'service.version': schemaString,
  'source.address': schemaString,
  'source.as.number': schemaStringOrNumber,
  'source.as.organization.name': schemaString,
  'source.bytes': schemaStringOrNumber,
  'source.domain': schemaString,
  'source.geo.city_name': schemaString,
  'source.geo.continent_code': schemaString,
  'source.geo.continent_name': schemaString,
  'source.geo.country_iso_code': schemaString,
  'source.geo.country_name': schemaString,
  'source.geo.location': schemaGeoPoint,
  'source.geo.name': schemaString,
  'source.geo.postal_code': schemaString,
  'source.geo.region_iso_code': schemaString,
  'source.geo.region_name': schemaString,
  'source.geo.timezone': schemaString,
  'source.ip': schemaString,
  'source.mac': schemaString,
  'source.nat.ip': schemaString,
  'source.nat.port': schemaStringOrNumber,
  'source.packets': schemaStringOrNumber,
  'source.port': schemaStringOrNumber,
  'source.registered_domain': schemaString,
  'source.subdomain': schemaString,
  'source.top_level_domain': schemaString,
  'source.user.domain': schemaString,
  'source.user.email': schemaString,
  'source.user.full_name': schemaString,
  'source.user.group.domain': schemaString,
  'source.user.group.id': schemaString,
  'source.user.group.name': schemaString,
  'source.user.hash': schemaString,
  'source.user.id': schemaString,
  'source.user.name': schemaString,
  'source.user.roles': schemaStringArray,
  'span.id': schemaString,
  tags: schemaStringArray,
  'threat.enrichments': rt.array(rt.partial({
    indicator: schemaUnknown,
    'matched.atomic': schemaString,
    'matched.field': schemaString,
    'matched.id': schemaString,
    'matched.index': schemaString,
    'matched.occurred': schemaDate,
    'matched.type': schemaString
  })),
  'threat.feed.dashboard_id': schemaString,
  'threat.feed.description': schemaString,
  'threat.feed.name': schemaString,
  'threat.feed.reference': schemaString,
  'threat.framework': schemaString,
  'threat.group.alias': schemaStringArray,
  'threat.group.id': schemaString,
  'threat.group.name': schemaString,
  'threat.group.reference': schemaString,
  'threat.indicator.as.number': schemaStringOrNumber,
  'threat.indicator.as.organization.name': schemaString,
  'threat.indicator.confidence': schemaString,
  'threat.indicator.description': schemaString,
  'threat.indicator.email.address': schemaString,
  'threat.indicator.file.accessed': schemaDate,
  'threat.indicator.file.attributes': schemaStringArray,
  'threat.indicator.file.code_signature.digest_algorithm': schemaString,
  'threat.indicator.file.code_signature.exists': schemaBoolean,
  'threat.indicator.file.code_signature.flags': schemaString,
  'threat.indicator.file.code_signature.signing_id': schemaString,
  'threat.indicator.file.code_signature.status': schemaString,
  'threat.indicator.file.code_signature.subject_name': schemaString,
  'threat.indicator.file.code_signature.team_id': schemaString,
  'threat.indicator.file.code_signature.timestamp': schemaDate,
  'threat.indicator.file.code_signature.trusted': schemaBoolean,
  'threat.indicator.file.code_signature.valid': schemaBoolean,
  'threat.indicator.file.created': schemaDate,
  'threat.indicator.file.ctime': schemaDate,
  'threat.indicator.file.device': schemaString,
  'threat.indicator.file.directory': schemaString,
  'threat.indicator.file.drive_letter': schemaString,
  'threat.indicator.file.elf.architecture': schemaString,
  'threat.indicator.file.elf.byte_order': schemaString,
  'threat.indicator.file.elf.cpu_type': schemaString,
  'threat.indicator.file.elf.creation_date': schemaDate,
  'threat.indicator.file.elf.exports': schemaUnknownArray,
  'threat.indicator.file.elf.go_import_hash': schemaString,
  'threat.indicator.file.elf.go_imports': schemaUnknown,
  'threat.indicator.file.elf.go_imports_names_entropy': schemaStringOrNumber,
  'threat.indicator.file.elf.go_imports_names_var_entropy': schemaStringOrNumber,
  'threat.indicator.file.elf.go_stripped': schemaBoolean,
  'threat.indicator.file.elf.header.abi_version': schemaString,
  'threat.indicator.file.elf.header.class': schemaString,
  'threat.indicator.file.elf.header.data': schemaString,
  'threat.indicator.file.elf.header.entrypoint': schemaStringOrNumber,
  'threat.indicator.file.elf.header.object_version': schemaString,
  'threat.indicator.file.elf.header.os_abi': schemaString,
  'threat.indicator.file.elf.header.type': schemaString,
  'threat.indicator.file.elf.header.version': schemaString,
  'threat.indicator.file.elf.import_hash': schemaString,
  'threat.indicator.file.elf.imports': schemaUnknownArray,
  'threat.indicator.file.elf.imports_names_entropy': schemaStringOrNumber,
  'threat.indicator.file.elf.imports_names_var_entropy': schemaStringOrNumber,
  'threat.indicator.file.elf.sections': rt.array(rt.partial({
    chi2: schemaStringOrNumber,
    entropy: schemaStringOrNumber,
    flags: schemaString,
    name: schemaString,
    physical_offset: schemaString,
    physical_size: schemaStringOrNumber,
    type: schemaString,
    var_entropy: schemaStringOrNumber,
    virtual_address: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'threat.indicator.file.elf.segments': rt.array(rt.partial({
    sections: schemaString,
    type: schemaString
  })),
  'threat.indicator.file.elf.shared_libraries': schemaStringArray,
  'threat.indicator.file.elf.telfhash': schemaString,
  'threat.indicator.file.extension': schemaString,
  'threat.indicator.file.fork_name': schemaString,
  'threat.indicator.file.gid': schemaString,
  'threat.indicator.file.group': schemaString,
  'threat.indicator.file.hash.cdhash': schemaString,
  'threat.indicator.file.hash.md5': schemaString,
  'threat.indicator.file.hash.sha1': schemaString,
  'threat.indicator.file.hash.sha256': schemaString,
  'threat.indicator.file.hash.sha384': schemaString,
  'threat.indicator.file.hash.sha512': schemaString,
  'threat.indicator.file.hash.ssdeep': schemaString,
  'threat.indicator.file.hash.tlsh': schemaString,
  'threat.indicator.file.inode': schemaString,
  'threat.indicator.file.mime_type': schemaString,
  'threat.indicator.file.mode': schemaString,
  'threat.indicator.file.mtime': schemaDate,
  'threat.indicator.file.name': schemaString,
  'threat.indicator.file.origin_referrer_url': schemaString,
  'threat.indicator.file.origin_url': schemaString,
  'threat.indicator.file.owner': schemaString,
  'threat.indicator.file.path': schemaString,
  'threat.indicator.file.pe.architecture': schemaString,
  'threat.indicator.file.pe.company': schemaString,
  'threat.indicator.file.pe.description': schemaString,
  'threat.indicator.file.pe.file_version': schemaString,
  'threat.indicator.file.pe.go_import_hash': schemaString,
  'threat.indicator.file.pe.go_imports': schemaUnknown,
  'threat.indicator.file.pe.go_imports_names_entropy': schemaStringOrNumber,
  'threat.indicator.file.pe.go_imports_names_var_entropy': schemaStringOrNumber,
  'threat.indicator.file.pe.go_stripped': schemaBoolean,
  'threat.indicator.file.pe.imphash': schemaString,
  'threat.indicator.file.pe.import_hash': schemaString,
  'threat.indicator.file.pe.imports': schemaUnknownArray,
  'threat.indicator.file.pe.imports_names_entropy': schemaStringOrNumber,
  'threat.indicator.file.pe.imports_names_var_entropy': schemaStringOrNumber,
  'threat.indicator.file.pe.original_file_name': schemaString,
  'threat.indicator.file.pe.pehash': schemaString,
  'threat.indicator.file.pe.product': schemaString,
  'threat.indicator.file.pe.sections': rt.array(rt.partial({
    entropy: schemaStringOrNumber,
    name: schemaString,
    physical_size: schemaStringOrNumber,
    var_entropy: schemaStringOrNumber,
    virtual_size: schemaStringOrNumber
  })),
  'threat.indicator.file.size': schemaStringOrNumber,
  'threat.indicator.file.target_path': schemaString,
  'threat.indicator.file.type': schemaString,
  'threat.indicator.file.uid': schemaString,
  'threat.indicator.file.x509.alternative_names': schemaStringArray,
  'threat.indicator.file.x509.issuer.common_name': schemaStringArray,
  'threat.indicator.file.x509.issuer.country': schemaStringArray,
  'threat.indicator.file.x509.issuer.distinguished_name': schemaString,
  'threat.indicator.file.x509.issuer.locality': schemaStringArray,
  'threat.indicator.file.x509.issuer.organization': schemaStringArray,
  'threat.indicator.file.x509.issuer.organizational_unit': schemaStringArray,
  'threat.indicator.file.x509.issuer.state_or_province': schemaStringArray,
  'threat.indicator.file.x509.not_after': schemaDate,
  'threat.indicator.file.x509.not_before': schemaDate,
  'threat.indicator.file.x509.public_key_algorithm': schemaString,
  'threat.indicator.file.x509.public_key_curve': schemaString,
  'threat.indicator.file.x509.public_key_exponent': schemaStringOrNumber,
  'threat.indicator.file.x509.public_key_size': schemaStringOrNumber,
  'threat.indicator.file.x509.serial_number': schemaString,
  'threat.indicator.file.x509.signature_algorithm': schemaString,
  'threat.indicator.file.x509.subject.common_name': schemaStringArray,
  'threat.indicator.file.x509.subject.country': schemaStringArray,
  'threat.indicator.file.x509.subject.distinguished_name': schemaString,
  'threat.indicator.file.x509.subject.locality': schemaStringArray,
  'threat.indicator.file.x509.subject.organization': schemaStringArray,
  'threat.indicator.file.x509.subject.organizational_unit': schemaStringArray,
  'threat.indicator.file.x509.subject.state_or_province': schemaStringArray,
  'threat.indicator.file.x509.version_number': schemaString,
  'threat.indicator.first_seen': schemaDate,
  'threat.indicator.geo.city_name': schemaString,
  'threat.indicator.geo.continent_code': schemaString,
  'threat.indicator.geo.continent_name': schemaString,
  'threat.indicator.geo.country_iso_code': schemaString,
  'threat.indicator.geo.country_name': schemaString,
  'threat.indicator.geo.location': schemaGeoPoint,
  'threat.indicator.geo.name': schemaString,
  'threat.indicator.geo.postal_code': schemaString,
  'threat.indicator.geo.region_iso_code': schemaString,
  'threat.indicator.geo.region_name': schemaString,
  'threat.indicator.geo.timezone': schemaString,
  'threat.indicator.id': schemaStringArray,
  'threat.indicator.ip': schemaString,
  'threat.indicator.last_seen': schemaDate,
  'threat.indicator.marking.tlp': schemaString,
  'threat.indicator.marking.tlp_version': schemaString,
  'threat.indicator.modified_at': schemaDate,
  'threat.indicator.name': schemaString,
  'threat.indicator.port': schemaStringOrNumber,
  'threat.indicator.provider': schemaString,
  'threat.indicator.reference': schemaString,
  'threat.indicator.registry.data.bytes': schemaString,
  'threat.indicator.registry.data.strings': schemaStringArray,
  'threat.indicator.registry.data.type': schemaString,
  'threat.indicator.registry.hive': schemaString,
  'threat.indicator.registry.key': schemaString,
  'threat.indicator.registry.path': schemaString,
  'threat.indicator.registry.value': schemaString,
  'threat.indicator.scanner_stats': schemaStringOrNumber,
  'threat.indicator.sightings': schemaStringOrNumber,
  'threat.indicator.type': schemaString,
  'threat.indicator.url.domain': schemaString,
  'threat.indicator.url.extension': schemaString,
  'threat.indicator.url.fragment': schemaString,
  'threat.indicator.url.full': schemaString,
  'threat.indicator.url.original': schemaString,
  'threat.indicator.url.password': schemaString,
  'threat.indicator.url.path': schemaString,
  'threat.indicator.url.port': schemaStringOrNumber,
  'threat.indicator.url.query': schemaString,
  'threat.indicator.url.registered_domain': schemaString,
  'threat.indicator.url.scheme': schemaString,
  'threat.indicator.url.subdomain': schemaString,
  'threat.indicator.url.top_level_domain': schemaString,
  'threat.indicator.url.username': schemaString,
  'threat.indicator.x509.alternative_names': schemaStringArray,
  'threat.indicator.x509.issuer.common_name': schemaStringArray,
  'threat.indicator.x509.issuer.country': schemaStringArray,
  'threat.indicator.x509.issuer.distinguished_name': schemaString,
  'threat.indicator.x509.issuer.locality': schemaStringArray,
  'threat.indicator.x509.issuer.organization': schemaStringArray,
  'threat.indicator.x509.issuer.organizational_unit': schemaStringArray,
  'threat.indicator.x509.issuer.state_or_province': schemaStringArray,
  'threat.indicator.x509.not_after': schemaDate,
  'threat.indicator.x509.not_before': schemaDate,
  'threat.indicator.x509.public_key_algorithm': schemaString,
  'threat.indicator.x509.public_key_curve': schemaString,
  'threat.indicator.x509.public_key_exponent': schemaStringOrNumber,
  'threat.indicator.x509.public_key_size': schemaStringOrNumber,
  'threat.indicator.x509.serial_number': schemaString,
  'threat.indicator.x509.signature_algorithm': schemaString,
  'threat.indicator.x509.subject.common_name': schemaStringArray,
  'threat.indicator.x509.subject.country': schemaStringArray,
  'threat.indicator.x509.subject.distinguished_name': schemaString,
  'threat.indicator.x509.subject.locality': schemaStringArray,
  'threat.indicator.x509.subject.organization': schemaStringArray,
  'threat.indicator.x509.subject.organizational_unit': schemaStringArray,
  'threat.indicator.x509.subject.state_or_province': schemaStringArray,
  'threat.indicator.x509.version_number': schemaString,
  'threat.software.alias': schemaStringArray,
  'threat.software.id': schemaString,
  'threat.software.name': schemaString,
  'threat.software.platforms': schemaStringArray,
  'threat.software.reference': schemaString,
  'threat.software.type': schemaString,
  'threat.tactic.id': schemaStringArray,
  'threat.tactic.name': schemaStringArray,
  'threat.tactic.reference': schemaStringArray,
  'threat.technique.id': schemaStringArray,
  'threat.technique.name': schemaStringArray,
  'threat.technique.reference': schemaStringArray,
  'threat.technique.subtechnique.id': schemaStringArray,
  'threat.technique.subtechnique.name': schemaStringArray,
  'threat.technique.subtechnique.reference': schemaStringArray,
  'tls.cipher': schemaString,
  'tls.client.certificate': schemaString,
  'tls.client.certificate_chain': schemaStringArray,
  'tls.client.hash.md5': schemaString,
  'tls.client.hash.sha1': schemaString,
  'tls.client.hash.sha256': schemaString,
  'tls.client.issuer': schemaString,
  'tls.client.ja3': schemaString,
  'tls.client.not_after': schemaDate,
  'tls.client.not_before': schemaDate,
  'tls.client.server_name': schemaString,
  'tls.client.subject': schemaString,
  'tls.client.supported_ciphers': schemaStringArray,
  'tls.client.x509.alternative_names': schemaStringArray,
  'tls.client.x509.issuer.common_name': schemaStringArray,
  'tls.client.x509.issuer.country': schemaStringArray,
  'tls.client.x509.issuer.distinguished_name': schemaString,
  'tls.client.x509.issuer.locality': schemaStringArray,
  'tls.client.x509.issuer.organization': schemaStringArray,
  'tls.client.x509.issuer.organizational_unit': schemaStringArray,
  'tls.client.x509.issuer.state_or_province': schemaStringArray,
  'tls.client.x509.not_after': schemaDate,
  'tls.client.x509.not_before': schemaDate,
  'tls.client.x509.public_key_algorithm': schemaString,
  'tls.client.x509.public_key_curve': schemaString,
  'tls.client.x509.public_key_exponent': schemaStringOrNumber,
  'tls.client.x509.public_key_size': schemaStringOrNumber,
  'tls.client.x509.serial_number': schemaString,
  'tls.client.x509.signature_algorithm': schemaString,
  'tls.client.x509.subject.common_name': schemaStringArray,
  'tls.client.x509.subject.country': schemaStringArray,
  'tls.client.x509.subject.distinguished_name': schemaString,
  'tls.client.x509.subject.locality': schemaStringArray,
  'tls.client.x509.subject.organization': schemaStringArray,
  'tls.client.x509.subject.organizational_unit': schemaStringArray,
  'tls.client.x509.subject.state_or_province': schemaStringArray,
  'tls.client.x509.version_number': schemaString,
  'tls.curve': schemaString,
  'tls.established': schemaBoolean,
  'tls.next_protocol': schemaString,
  'tls.resumed': schemaBoolean,
  'tls.server.certificate': schemaString,
  'tls.server.certificate_chain': schemaStringArray,
  'tls.server.hash.md5': schemaString,
  'tls.server.hash.sha1': schemaString,
  'tls.server.hash.sha256': schemaString,
  'tls.server.issuer': schemaString,
  'tls.server.ja3s': schemaString,
  'tls.server.not_after': schemaDate,
  'tls.server.not_before': schemaDate,
  'tls.server.subject': schemaString,
  'tls.server.x509.alternative_names': schemaStringArray,
  'tls.server.x509.issuer.common_name': schemaStringArray,
  'tls.server.x509.issuer.country': schemaStringArray,
  'tls.server.x509.issuer.distinguished_name': schemaString,
  'tls.server.x509.issuer.locality': schemaStringArray,
  'tls.server.x509.issuer.organization': schemaStringArray,
  'tls.server.x509.issuer.organizational_unit': schemaStringArray,
  'tls.server.x509.issuer.state_or_province': schemaStringArray,
  'tls.server.x509.not_after': schemaDate,
  'tls.server.x509.not_before': schemaDate,
  'tls.server.x509.public_key_algorithm': schemaString,
  'tls.server.x509.public_key_curve': schemaString,
  'tls.server.x509.public_key_exponent': schemaStringOrNumber,
  'tls.server.x509.public_key_size': schemaStringOrNumber,
  'tls.server.x509.serial_number': schemaString,
  'tls.server.x509.signature_algorithm': schemaString,
  'tls.server.x509.subject.common_name': schemaStringArray,
  'tls.server.x509.subject.country': schemaStringArray,
  'tls.server.x509.subject.distinguished_name': schemaString,
  'tls.server.x509.subject.locality': schemaStringArray,
  'tls.server.x509.subject.organization': schemaStringArray,
  'tls.server.x509.subject.organizational_unit': schemaStringArray,
  'tls.server.x509.subject.state_or_province': schemaStringArray,
  'tls.server.x509.version_number': schemaString,
  'tls.version': schemaString,
  'tls.version_protocol': schemaString,
  'trace.id': schemaString,
  'transaction.id': schemaString,
  'url.domain': schemaString,
  'url.extension': schemaString,
  'url.fragment': schemaString,
  'url.full': schemaString,
  'url.original': schemaString,
  'url.password': schemaString,
  'url.path': schemaString,
  'url.port': schemaStringOrNumber,
  'url.query': schemaString,
  'url.registered_domain': schemaString,
  'url.scheme': schemaString,
  'url.subdomain': schemaString,
  'url.top_level_domain': schemaString,
  'url.username': schemaString,
  'user.changes.domain': schemaString,
  'user.changes.email': schemaString,
  'user.changes.full_name': schemaString,
  'user.changes.group.domain': schemaString,
  'user.changes.group.id': schemaString,
  'user.changes.group.name': schemaString,
  'user.changes.hash': schemaString,
  'user.changes.id': schemaString,
  'user.changes.name': schemaString,
  'user.changes.roles': schemaStringArray,
  'user.domain': schemaString,
  'user.effective.domain': schemaString,
  'user.effective.email': schemaString,
  'user.effective.full_name': schemaString,
  'user.effective.group.domain': schemaString,
  'user.effective.group.id': schemaString,
  'user.effective.group.name': schemaString,
  'user.effective.hash': schemaString,
  'user.effective.id': schemaString,
  'user.effective.name': schemaString,
  'user.effective.roles': schemaStringArray,
  'user.email': schemaString,
  'user.full_name': schemaString,
  'user.group.domain': schemaString,
  'user.group.id': schemaString,
  'user.group.name': schemaString,
  'user.hash': schemaString,
  'user.id': schemaString,
  'user.name': schemaString,
  'user.risk.calculated_level': schemaString,
  'user.risk.calculated_score': schemaNumber,
  'user.risk.calculated_score_norm': schemaNumber,
  'user.risk.static_level': schemaString,
  'user.risk.static_score': schemaNumber,
  'user.risk.static_score_norm': schemaNumber,
  'user.roles': schemaStringArray,
  'user.target.domain': schemaString,
  'user.target.email': schemaString,
  'user.target.full_name': schemaString,
  'user.target.group.domain': schemaString,
  'user.target.group.id': schemaString,
  'user.target.group.name': schemaString,
  'user.target.hash': schemaString,
  'user.target.id': schemaString,
  'user.target.name': schemaString,
  'user.target.roles': schemaStringArray,
  'user_agent.device.name': schemaString,
  'user_agent.name': schemaString,
  'user_agent.original': schemaString,
  'user_agent.os.family': schemaString,
  'user_agent.os.full': schemaString,
  'user_agent.os.kernel': schemaString,
  'user_agent.os.name': schemaString,
  'user_agent.os.platform': schemaString,
  'user_agent.os.type': schemaString,
  'user_agent.os.version': schemaString,
  'user_agent.version': schemaString,
  'volume.bus_type': schemaString,
  'volume.default_access': schemaString,
  'volume.device_name': schemaString,
  'volume.device_type': schemaString,
  'volume.dos_name': schemaString,
  'volume.file_system_type': schemaString,
  'volume.mount_name': schemaString,
  'volume.nt_name': schemaString,
  'volume.product_id': schemaString,
  'volume.product_name': schemaString,
  'volume.removable': schemaBoolean,
  'volume.serial_number': schemaString,
  'volume.size': schemaStringOrNumber,
  'volume.vendor_id': schemaString,
  'volume.vendor_name': schemaString,
  'volume.writable': schemaBoolean,
  'vulnerability.category': schemaStringArray,
  'vulnerability.classification': schemaString,
  'vulnerability.description': schemaString,
  'vulnerability.enumeration': schemaString,
  'vulnerability.id': schemaString,
  'vulnerability.reference': schemaString,
  'vulnerability.report_id': schemaString,
  'vulnerability.scanner.vendor': schemaString,
  'vulnerability.score.base': schemaNumber,
  'vulnerability.score.environmental': schemaNumber,
  'vulnerability.score.temporal': schemaNumber,
  'vulnerability.score.version': schemaString,
  'vulnerability.severity': schemaString
});

// prettier-ignore
const EcsSchema = exports.EcsSchema = rt.intersection([EcsRequired, EcsOptional]);
// prettier-ignore