"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiFlyoutSession = useEuiFlyoutSession;
var _react = require("react");
var _flyout_provider = require("./flyout_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Hook for accessing the flyout API
 * @public
 */
function useEuiFlyoutSession() {
  var _state$activeFlyoutGr, _state$activeFlyoutGr2;
  var _useEuiFlyoutSessionC = (0, _flyout_provider.useEuiFlyoutSessionContext)(),
    state = _useEuiFlyoutSessionC.state,
    dispatch = _useEuiFlyoutSessionC.dispatch,
    onUnmount = _useEuiFlyoutSessionC.onUnmount;
  var isInitialMount = (0, _react.useRef)(true);
  (0, _react.useEffect)(function () {
    // When there is no active flyout, we should call the onUnmount callback.
    // Ensure this is not called on the initial render, only on subsequent state changes.
    if (isInitialMount.current) {
      isInitialMount.current = false;
    } else if (state.activeFlyoutGroup === null) {
      onUnmount === null || onUnmount === void 0 || onUnmount();
    }
  }, [state.activeFlyoutGroup, onUnmount]);
  var openFlyout = function openFlyout(options) {
    dispatch({
      type: 'OPEN_MAIN_FLYOUT',
      payload: options
    });
  };
  var openChildFlyout = function openChildFlyout(options) {
    if (!state.activeFlyoutGroup || !state.activeFlyoutGroup.isMainOpen) {
      console.warn('useEuiFlyoutApi: Cannot open child flyout when main flyout is not open.');
      return;
    }
    dispatch({
      type: 'OPEN_CHILD_FLYOUT',
      payload: options
    });
  };
  var openFlyoutGroup = function openFlyoutGroup(options) {
    dispatch({
      type: 'OPEN_FLYOUT_GROUP',
      payload: options
    });
  };
  var closeChildFlyout = function closeChildFlyout() {
    dispatch({
      type: 'CLOSE_CHILD_FLYOUT'
    });
  };
  var goBack = function goBack() {
    dispatch({
      type: 'GO_BACK'
    });
  };
  var closeSession = function closeSession() {
    dispatch({
      type: 'CLOSE_SESSION'
    });
  };
  var isFlyoutOpen = !!((_state$activeFlyoutGr = state.activeFlyoutGroup) !== null && _state$activeFlyoutGr !== void 0 && _state$activeFlyoutGr.isMainOpen);
  var isChildFlyoutOpen = !!((_state$activeFlyoutGr2 = state.activeFlyoutGroup) !== null && _state$activeFlyoutGr2 !== void 0 && _state$activeFlyoutGr2.isChildOpen);
  var canGoBack = !!state.history.length;
  return {
    openFlyout: openFlyout,
    openChildFlyout: openChildFlyout,
    openFlyoutGroup: openFlyoutGroup,
    closeChildFlyout: closeChildFlyout,
    goBack: goBack,
    closeSession: closeSession,
    isFlyoutOpen: isFlyoutOpen,
    isChildFlyoutOpen: isChildFlyoutOpen,
    canGoBack: canGoBack
  };
}