"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumnsConfiguration = exports.DataTableSummaryColumnHeaderTracesContext = void 0;
var _react = _interopRequireDefault(require("react"));
var _unifiedDataTable = require("@kbn/unified-data-table");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/context_awareness/profile_providers/observability/traces_data_source_profile/accessors/get_columns_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getColumnsConfiguration = prev => () => ({
  ...(prev ? prev() : {}),
  _source: ({
    column,
    headerRowHeight
  }) => ({
    ...column,
    display: /*#__PURE__*/_react.default.createElement(DataTableSummaryColumnHeaderTracesContext, {
      columnDisplayName: column.displayAsText,
      headerRowHeight: headerRowHeight,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 9
      }
    })
  })
});
exports.getColumnsConfiguration = getColumnsConfiguration;
const DataTableSummaryColumnHeaderTracesContext = ({
  headerRowHeight = 1,
  columnDisplayName
}) => {
  const tooltipTitle = _i18n.i18n.translate('discover.unifiedDataTable.tableHeader.tracesContext.sourceFieldIconTooltipTitle', {
    defaultMessage: 'Summary including the following fields'
  });
  const tooltipContent = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.unifiedDataTable.tableHeader.tracesContext.sourceFieldIconTooltip",
    defaultMessage: "Displays the most relevant resource identifiers like:{br}{br}- service.name{br}- event.outcome{br}- transaction.name{br}- etc.",
    values: {
      br: /*#__PURE__*/_react.default.createElement("br", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 21
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_unifiedDataTable.UnifiedDataTableSummaryColumnHeader, {
    columnDisplayName: columnDisplayName,
    headerRowHeight: headerRowHeight,
    tooltipTitle: tooltipTitle,
    tooltipContent: tooltipContent,
    iconTipDataTestSubj: "traces-summary-icon",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  });
};
exports.DataTableSummaryColumnHeaderTracesContext = DataTableSummaryColumnHeaderTracesContext;