"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverMainContent = void 0;
var _eui = require("@elastic/eui");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _view_mode_toggle = require("../../../../components/view_mode_toggle");
var _field_stats_table = require("../field_stats_table");
var _discover_documents = require("./discover_documents");
var _constants2 = require("../field_stats_table/constants");
var _discover_app_state_container = require("../../state_management/discover_app_state_container");
var _pattern_analysis_tab = require("../pattern_analysis/pattern_analysis_tab");
var _constants3 = require("../pattern_analysis/constants");
var _use_is_esql_mode = require("../../hooks/use_is_esql_mode");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/layout/discover_main_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DROP_PROPS = {
  value: {
    id: 'dscDropZoneTable',
    humanData: {
      label: _i18n.i18n.translate('discover.dropZoneTableLabel', {
        defaultMessage: 'Drop zone to add field as a column to the table'
      })
    }
  },
  order: [1, 0, 0, 0],
  types: ['field_add']
};
const DiscoverMainContent = ({
  dataView,
  viewMode,
  onAddFilter,
  onFieldEdited,
  columns,
  stateContainer,
  onDropFieldToTable,
  panelsToggle,
  isChartAvailable
}) => {
  const {
    trackUiMetric
  } = (0, _use_discover_services.useDiscoverServices)();
  const isEsqlMode = (0, _use_is_esql_mode.useIsEsqlMode)();
  const setDiscoverViewMode = (0, _react.useCallback)(mode => {
    stateContainer.appState.update({
      viewMode: mode
    }, true);
    if (trackUiMetric) {
      if (mode === _constants.VIEW_MODE.AGGREGATED_LEVEL) {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, _constants2.FIELD_STATISTICS_VIEW_CLICK);
      } else if (mode === _constants.VIEW_MODE.PATTERN_LEVEL) {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, _constants3.PATTERN_ANALYSIS_VIEW_CLICK);
      } else {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, _constants2.DOCUMENTS_VIEW_CLICK);
      }
    }
    return new Promise((resolve, reject) => {
      // return a promise to report when the view mode has been updated
      stateContainer.appState.subscribe(state => {
        if (state.viewMode === mode) {
          resolve(mode);
        } else {
          reject(mode);
        }
      });
    });
  }, [trackUiMetric, stateContainer]);
  const isDropAllowed = Boolean(onDropFieldToTable);
  const renderViewModeToggle = (0, _react.useCallback)(patternCount => {
    return /*#__PURE__*/_react.default.createElement(_view_mode_toggle.DocumentViewModeToggle, {
      viewMode: viewMode,
      isEsqlMode: isEsqlMode,
      stateContainer: stateContainer,
      setDiscoverViewMode: setDiscoverViewMode,
      patternCount: patternCount,
      dataView: dataView,
      prepend: /*#__PURE__*/_react.default.isValidElement(panelsToggle) ? /*#__PURE__*/_react.default.cloneElement(panelsToggle, {
        renderedFor: 'tabs',
        isChartAvailable
      }) : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    });
  }, [viewMode, isEsqlMode, stateContainer, setDiscoverViewMode, dataView, panelsToggle, isChartAvailable]);
  const viewModeToggle = (0, _react.useMemo)(() => renderViewModeToggle(), [renderViewModeToggle]);
  const showChart = (0, _discover_app_state_container.useAppStateSelector)(state => !state.hideChart);
  return /*#__PURE__*/_react.default.createElement(_domDragDrop.Droppable, {
    dropTypes: isDropAllowed ? DROP_PROPS.types : undefined,
    value: DROP_PROPS.value,
    order: DROP_PROPS.order,
    onDrop: onDropFieldToTable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_domDragDrop.DropOverlayWrapper, {
    isVisible: isDropAllowed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "eui-fullHeight",
    direction: "column",
    gutterSize: "none",
    responsive: false,
    "data-test-subj": "dscMainContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, showChart && isChartAvailable && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 45
    }
  }), viewMode === _constants.VIEW_MODE.DOCUMENT_LEVEL ? /*#__PURE__*/_react.default.createElement(_discover_documents.DiscoverDocuments, {
    viewModeToggle: viewModeToggle,
    dataView: dataView,
    onAddFilter: onAddFilter,
    stateContainer: stateContainer,
    onFieldEdited: !isEsqlMode ? onFieldEdited : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }) : null, viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 15
    }
  }, viewModeToggle), /*#__PURE__*/_react.default.createElement(_field_stats_table.FieldStatisticsTab, {
    dataView: dataView,
    columns: columns,
    stateContainer: stateContainer,
    onAddFilter: !isEsqlMode ? onAddFilter : undefined,
    trackUiMetric: trackUiMetric,
    isEsqlMode: isEsqlMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  })) : null, viewMode === _constants.VIEW_MODE.PATTERN_LEVEL ? /*#__PURE__*/_react.default.createElement(_pattern_analysis_tab.PatternAnalysisTab, {
    dataView: dataView,
    stateContainer: stateContainer,
    switchToDocumentView: () => setDiscoverViewMode(_constants.VIEW_MODE.DOCUMENT_LEVEL),
    trackUiMetric: trackUiMetric,
    renderViewModeToggle: renderViewModeToggle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }) : null)));
};
exports.DiscoverMainContent = DiscoverMainContent;