"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
var _kibana_services = require("../../../../kibana_services");
var _embeddable_error_msg = _interopRequireDefault(require("./embeddable_error_msg"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/embeddables/grid_embeddable/field_stats_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EmbeddableESQLFieldStatsTableWrapper = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable_esql_field_stats_table'))));
const EmbeddableFieldStatsTableWrapper = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./embeddable_field_stats_table'))));
function isESQLFieldStatisticTableEmbeddableState(input) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(input, ['isEsqlMode']) && input.isEsqlMode === true;
}
function isFieldStatisticTableEmbeddableState(input) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(input, ['dataView']) && Boolean(input.isEsqlMode) === false;
}
const FieldStatisticsWrapperContent = props => {
  if (isESQLFieldStatisticTableEmbeddableState(props)) {
    var _props$isEsqlMode;
    const isEsql = props.esqlQuery && (0, _esQuery.isOfAggregateQueryType)(props.esqlQuery);
    return isEsql ? /*#__PURE__*/_react.default.createElement(_embeddable_error_msg.default, {
      id: props.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(EmbeddableESQLFieldStatsTableWrapper, {
      id: props.id,
      dataView: props.dataView,
      esqlQuery: props.esqlQuery,
      isEsqlMode: (_props$isEsqlMode = props.isEsqlMode) !== null && _props$isEsqlMode !== void 0 ? _props$isEsqlMode : props.esql,
      filters: props.filters,
      lastReloadRequestTime: props.lastReloadRequestTime,
      onAddFilter: props.onAddFilter,
      onTableUpdate: props.onTableUpdate,
      query: props.query,
      samplingOption: props.samplingOption,
      savedSearch: props.savedSearch,
      sessionId: props.sessionId,
      shouldGetSubfields: props.shouldGetSubfields,
      showPreviewByDefault: props.showPreviewByDefault,
      totalDocuments: props.totalDocuments,
      timeRange: props.timeRange,
      visibleFieldNames: props.visibleFieldNames,
      resetData$: props.resetData$,
      onRenderComplete: props.onRenderComplete,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    });
  }
  if (isFieldStatisticTableEmbeddableState(props)) {
    return /*#__PURE__*/_react.default.createElement(EmbeddableFieldStatsTableWrapper, {
      id: props.id,
      dataView: props.dataView,
      isEsqlMode: false,
      filters: props.filters,
      lastReloadRequestTime: props.lastReloadRequestTime,
      onAddFilter: props.onAddFilter,
      onTableUpdate: props.onTableUpdate,
      query: props.query,
      samplingOption: props.samplingOption,
      savedSearch: props.savedSearch,
      sessionId: props.sessionId,
      shouldGetSubfields: props.shouldGetSubfields,
      showPreviewByDefault: props.showPreviewByDefault,
      totalDocuments: props.totalDocuments,
      timeRange: props.timeRange,
      visibleFieldNames: props.visibleFieldNames,
      resetData$: props.resetData$,
      onRenderComplete: props.onRenderComplete,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 7
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      iconColor: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.index.embeddableErrorTitle",
        defaultMessage: "Error loading embeddable",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.index.embeddableErrorDescription",
        defaultMessage: "There was an error loading the embeddable. Please check if all the required input is valid.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 7
      }
    });
  }
};
const FieldStatisticsWrapper = props => {
  var _props$isEsqlMode2;
  const coreStart = (0, _kibana_services.getCoreStart)();
  const {
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    lens,
    dataViewFieldEditor,
    uiActions,
    charts,
    unifiedSearch
  } = (0, _kibana_services.getPluginsStart)();
  const services = {
    ...coreStart,
    data,
    maps,
    embeddable,
    share,
    fileUpload,
    lens,
    dataViewFieldEditor,
    uiActions,
    charts,
    unifiedSearch
  };
  const {
    overridableServices
  } = props;
  const kibanaRenderServices = (0, _react.useMemo)(() => (0, _lodash.pick)(coreStart, 'analytics', 'i18n', 'theme', 'userProfile'),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const servicesWithOverrides = (0, _react.useMemo)(() => ({
    ...services,
    ...(overridableServices !== null && overridableServices !== void 0 ? overridableServices : {})
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const datePickerDeps = (0, _react.useMemo)(() => ({
    ...(0, _lodash.pick)(servicesWithOverrides, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'userProfile', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS
  }), [servicesWithOverrides]);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, kibanaRenderServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: servicesWithOverrides,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, (0, _extends2.default)({}, datePickerDeps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(FieldStatisticsWrapperContent, {
    id: props.id,
    dataView: props.dataView,
    isEsqlMode: (_props$isEsqlMode2 = props.isEsqlMode) !== null && _props$isEsqlMode2 !== void 0 ? _props$isEsqlMode2 : props.esql,
    esqlQuery: props.esqlQuery,
    filters: props.filters,
    lastReloadRequestTime: props.lastReloadRequestTime,
    onAddFilter: props.onAddFilter,
    onTableUpdate: props.onTableUpdate,
    query: props.query,
    samplingOption: props.samplingOption,
    savedSearch: props.savedSearch,
    sessionId: props.sessionId,
    shouldGetSubfields: props.shouldGetSubfields,
    showPreviewByDefault: props.showPreviewByDefault,
    totalDocuments: props.totalDocuments,
    visibleFieldNames: props.visibleFieldNames,
    resetData$: props.resetData$,
    timeRange: props.timeRange,
    onRenderComplete: props.onRenderComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }))));
};
// exporting as default so it can be used with React.lazy
// eslint-disable-next-line import/no-default-export
var _default = exports.default = FieldStatisticsWrapper;
module.exports = exports.default;