"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LINE_LIMIT = exports.GrokHighlighter = void 0;
var _public = require("@kbn/file-upload-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LINE_LIMIT = exports.LINE_LIMIT = 5;
class GrokHighlighter extends _public.MessageImporter {
  constructor(options, http) {
    super(options);
    this.http = http;
  }
  async createLines(text, grokPattern, mappings, ecsCompatibility) {
    const docs = this._reader._createDocs(text, false, LINE_LIMIT);
    const lines = docs.docs.map(doc => doc.message);
    const matches = await this.testGrokPattern(lines, grokPattern, ecsCompatibility);
    return lines.map((line, index) => {
      const {
        matched,
        fields
      } = matches[index];
      if (matched === false) {
        return [{
          word: line
        }];
      }
      const sortedFields = Object.entries(fields).map(([fieldName, [{
        match,
        offset,
        length
      }]]) => {
        var _mappings$properties$;
        let type = (_mappings$properties$ = mappings.properties[fieldName]) === null || _mappings$properties$ === void 0 ? void 0 : _mappings$properties$.type;
        if (type === undefined && fieldName === 'timestamp') {
          var _mappings$properties$2;
          // it's possible that the timestamp field is not mapped as `timestamp`
          // but instead as `@timestamp`
          type = (_mappings$properties$2 = mappings.properties['@timestamp']) === null || _mappings$properties$2 === void 0 ? void 0 : _mappings$properties$2.type;
        }
        return {
          name: fieldName,
          match,
          offset,
          length,
          type
        };
      }).sort((a, b) => a.offset - b.offset);
      let offset = 0;
      const highlightedLine = [];
      for (const field of sortedFields) {
        highlightedLine.push({
          word: line.substring(offset, field.offset)
        });
        highlightedLine.push({
          word: field.match,
          field: {
            type: field.type,
            name: field.name
          }
        });
        offset = field.offset + field.length;
      }
      highlightedLine.push({
        word: line.substring(offset)
      });
      return highlightedLine;
    });
  }
  async testGrokPattern(lines, grokPattern, ecsCompatibility) {
    const {
      matches
    } = await this.http.fetch('/internal/data_visualizer/test_grok_pattern', {
      method: 'POST',
      version: '1',
      body: JSON.stringify({
        grokPattern,
        text: lines,
        ecsCompatibility
      })
    });
    return matches;
  }
}
exports.GrokHighlighter = GrokHighlighter;