"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCharsetOptions = getCharsetOptions;
exports.getDelimiterOptions = getDelimiterOptions;
exports.getFormatOptions = getFormatOptions;
exports.getQuoteOptions = getQuoteOptions;
exports.getTimestampFormatOptions = getTimestampFormatOptions;
var _fileUploadCommon = require("@kbn/file-upload-common");
var _option_lists = require("./option_lists");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getOptions(list) {
  return list.map(o => ({
    label: o
  }));
}
function getFormatOptions() {
  return getOptions(Object.values(_fileUploadCommon.FILE_FORMATS));
}
function getTimestampFormatOptions() {
  return getOptions(_option_lists.TIMESTAMP_OPTIONS);
}
function getDelimiterOptions() {
  return getOptions(_option_lists.DELIMITER_OPTIONS);
}
function getQuoteOptions() {
  return getOptions(_option_lists.QUOTE_OPTIONS);
}
function getCharsetOptions() {
  return getOptions(_option_lists.CHARSET_OPTIONS);
}