"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternTableContainerRouter = exports.IndexPatternTableContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _reactRouterDom = require("react-router-dom");
var _public2 = require("@kbn/data-views-plugin/public");
var _i18n = require("@kbn/i18n");
var _index_pattern_table = require("./index_pattern_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/index_pattern_table/index_pattern_table_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const title = _i18n.i18n.translate('indexPatternManagement.dataViewTable.title', {
  defaultMessage: 'Data Views'
});
const IndexPatternTableContainer = ({
  history,
  canSave,
  showCreateDialog: initialShowCreateDialog = false
}) => {
  const {
    dataViews,
    IndexPatternEditor
  } = (0, _public.useKibana)().services;
  const [showCreateDialog, setShowCreateDialog] = (0, _react.useState)(initialShowCreateDialog !== null && initialShowCreateDialog !== void 0 ? initialShowCreateDialog : false);
  const isRollup = new URLSearchParams((0, _reactRouterDom.useLocation)().search).get('type') === _public2.DataViewType.ROLLUP && dataViews.getRollupsEnabled();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "indexPatternTable",
    role: "region",
    "aria-label": title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_index_pattern_table.IndexPatternTableWithRouter, {
    canSave: canSave,
    setShowCreateDialog: setShowCreateDialog,
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }), showCreateDialog && /*#__PURE__*/_react.default.createElement(IndexPatternEditor, {
    onSave: indexPattern => {
      history.push(`patterns/${indexPattern.id}`);
    },
    onCancel: () => setShowCreateDialog(false),
    defaultTypeIsRollup: isRollup,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }));
};
exports.IndexPatternTableContainer = IndexPatternTableContainer;
const IndexPatternTableContainerRouter = exports.IndexPatternTableContainerRouter = (0, _reactRouterDom.withRouter)(IndexPatternTableContainer);