"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldPreviewError = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _state_utils = require("../../state_utils");
var _field_preview_context = require("./field_preview_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_field_editor/public/components/preview/field_preview_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const fetchDocErrorSelector = state => state.fetchDocError;
const FieldPreviewError = () => {
  var _fetchDocError$error$;
  const {
    controller
  } = (0, _field_preview_context.useFieldPreviewContext)();
  const fetchDocError = (0, _state_utils.useStateSelector)(controller.state$, fetchDocErrorSelector);
  if (fetchDocError === null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('indexPatternFieldEditor.fieldPreview.errorCallout.title', {
      defaultMessage: 'Error fetching document'
    }),
    color: "danger",
    iconType: "error",
    role: "alert",
    "data-test-subj": "fetchDocError",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, (_fetchDocError$error$ = fetchDocError.error.message) !== null && _fetchDocError$error$ !== void 0 ? _fetchDocError$error$ : fetchDocError.error.reason));
};
exports.FieldPreviewError = FieldPreviewError;