"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRenameActionDescriptor = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/search/session/sessions_mgmt/components/table/actions/rename_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RenameDialog = ({
  onActionDismiss,
  ...props
}) => {
  const {
    api,
    searchSession
  } = props;
  const {
    id,
    name: originalName
  } = searchSession;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [newName, setNewName] = (0, _react.useState)(originalName);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const bgsTitle = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.backgroundSearchTitle', {
    defaultMessage: 'Edit background search name'
  });
  const confirm = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.renameButton', {
    defaultMessage: 'Save'
  });
  const cancel = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.cancelButton', {
    defaultMessage: 'Cancel'
  });
  const bgsLabel = _i18n.i18n.translate('data.mgmt.searchSessions.renameModal.backgroundSearchNameInputLabel', {
    defaultMessage: 'Background search name'
  });
  const isNewNameValid = newName && originalName !== newName;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onActionDismiss,
    "aria-labelledby": modalTitleId,
    initialFocus: "[name=newName]",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, bgsTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: bgsLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "editNameInput",
    name: "newName",
    placeholder: originalName,
    value: newName,
    onChange: e => setNewName(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onActionDismiss,
    "data-test-subj": "cancelEditName",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, cancel), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "confirmEditName",
    disabled: !isNewNameValid,
    onClick: async () => {
      if (!isNewNameValid) return;
      setIsLoading(true);
      await api.sendRename(id, newName);
      setIsLoading(false);
      onActionDismiss();
    },
    fill: true,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, confirm)));
};
const createRenameActionDescriptor = (api, uiSession, core) => ({
  iconType: 'pencil',
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "data.mgmt.searchSessions.actionRename",
    defaultMessage: "Edit name",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 10
    }
  }),
  onClick: async () => {
    const ref = core.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(RenameDialog, {
      onActionDismiss: () => ref === null || ref === void 0 ? void 0 : ref.close(),
      api: api,
      searchSession: uiSession,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    }), core));
    await ref.onClose;
  }
});
exports.createRenameActionDescriptor = createRenameActionDescriptor;