"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListFetchCache = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lruCache = require("lru-cache");
var _objectHash = _interopRequireDefault(require("object-hash"));
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _public = require("@kbn/data-plugin/public");
var _esQuery = require("@kbn/es-query");
var _kibana_services = require("../../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const REQUEST_CACHE_SIZE = 50; // only store a max of 50 responses
const REQUEST_CACHE_TTL = 1000 * 60; // time to live = 1 minute

const optionsListResponseWasFailure = response => {
  return response.error !== undefined;
};
class OptionsListFetchCache {
  constructor() {
    (0, _defineProperty2.default)(this, "cache", void 0);
    (0, _defineProperty2.default)(this, "getRequestHash", request => {
      const {
        size,
        sort,
        query,
        filters,
        timeRange,
        searchString,
        runPastTimeout,
        selectedOptions,
        searchTechnique,
        ignoreValidations,
        field: {
          name: fieldName
        },
        dataView: {
          title: dataViewTitle
        }
      } = request;
      return (0, _objectHash.default)({
        // round timeRange to the minute to avoid cache misses
        timeRange: timeRange ? JSON.stringify({
          from: _datemath.default.parse(timeRange.from).startOf('minute').toISOString(),
          to: _datemath.default.parse(timeRange.to).endOf('minute').toISOString()
        }) : [],
        selectedOptions,
        filters,
        query,
        sort,
        searchTechnique,
        ignoreValidations,
        runPastTimeout,
        dataViewTitle,
        searchString: searchString !== null && searchString !== void 0 ? searchString : '',
        fieldName,
        size
      });
    });
    (0, _defineProperty2.default)(this, "clearCache", () => {
      this.cache.clear();
    });
    this.cache = new _lruCache.LRUCache({
      max: REQUEST_CACHE_SIZE,
      ttl: REQUEST_CACHE_TTL
    });
  }
  async runFetchRequest(request, abortSignal) {
    const requestHash = this.getRequestHash(request);
    if (this.cache.has(requestHash)) {
      return Promise.resolve(this.cache.get(requestHash));
    } else {
      var _dataView$toSpec;
      const index = request.dataView.getIndexPattern();
      const timeService = _kibana_services.dataService.query.timefilter.timefilter;
      const {
        query,
        filters,
        dataView,
        timeRange,
        field,
        ...passThroughProps
      } = request;
      const timeFilter = timeRange ? timeService.createFilter(dataView, timeRange) : undefined;
      const filtersToUse = [...(filters !== null && filters !== void 0 ? filters : []), ...(timeFilter ? [timeFilter] : [])];
      const config = (0, _public.getEsQueryConfig)(_kibana_services.coreServices.uiSettings);
      const esFilters = [(0, _esQuery.buildEsQuery)(dataView, query !== null && query !== void 0 ? query : [], filtersToUse !== null && filtersToUse !== void 0 ? filtersToUse : [], config)];
      const requestBody = {
        ...passThroughProps,
        filters: esFilters,
        fieldName: field.name,
        fieldSpec: field,
        runtimeFieldMap: (_dataView$toSpec = dataView.toSpec) === null || _dataView$toSpec === void 0 ? void 0 : _dataView$toSpec.call(dataView, false).runtimeFieldMap
      };
      const result = await _kibana_services.coreServices.http.fetch(`/internal/controls/optionsList/${index}`, {
        version: '1',
        body: JSON.stringify(requestBody),
        signal: abortSignal,
        method: 'POST'
      });
      if (!optionsListResponseWasFailure(result)) {
        // only add the success responses to the cache
        this.cache.set(requestHash, result);
      }
      return result;
    }
  }
}
exports.OptionsListFetchCache = OptionsListFetchCache;