"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isIncludeAll = exports.contentPackIncludedObjectsSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const includeAllSchema = _zod.z.object({
  objects: _zod.z.object({
    all: _zod.z.strictObject({})
  })
});
const isIncludeAll = value => {
  return includeAllSchema.safeParse(value).success;
};
exports.isIncludeAll = isIncludeAll;
const contentPackIncludedObjectsSchema = exports.contentPackIncludedObjectsSchema = _zod.z.lazy(() => _zod.z.union([includeAllSchema, _zod.z.object({
  objects: _zod.z.object({
    mappings: _zod.z.boolean(),
    queries: _zod.z.array(_zod.z.object({
      id: _zod.z.string()
    })),
    routing: _zod.z.array(contentPackIncludedObjectsSchema.and(_zod.z.object({
      destination: _zod.z.string()
    })))
  })
})]));