"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeErrors = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const normalizeErrors = errors => errors.map(({
  error,
  timestamp,
  eventName
}) => ({
  eventName,
  error: {
    ...error,
    exception: (0, _lodash.castArray)(error === null || error === void 0 ? void 0 : error.exception)[0]
  },
  timestamp
}));
exports.normalizeErrors = normalizeErrors;