"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsTemplate = SettingsTemplate;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_default_environment = require("../../../hooks/use_default_environment");
var _apm_main_template = require("./apm_main_template");
var _use_apm_feature_flag = require("../../../hooks/use_apm_feature_flag");
var _apm_feature_flags = require("../../../../common/apm_feature_flags");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/templates/settings_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SettingsTemplate({
  children,
  selectedTab
}) {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const router = (0, _use_apm_router.useApmRouter)();
  const defaultEnvironment = (0, _use_default_environment.useDefaultEnvironment)();
  const agentConfigurationAvailable = (0, _use_apm_feature_flag.useApmFeatureFlag)(_apm_feature_flags.ApmFeatureFlagName.AgentConfigurationAvailable);
  const migrationToFleetAvailable = (0, _use_apm_feature_flag.useApmFeatureFlag)(_apm_feature_flags.ApmFeatureFlagName.MigrationToFleetAvailable);
  const indicesAvailable = (0, _use_apm_feature_flag.useApmFeatureFlag)(_apm_feature_flags.ApmFeatureFlagName.ConfigurableIndicesAvailable);
  const tabs = getTabs({
    core,
    selectedTab,
    router,
    defaultEnvironment,
    agentConfigurationAvailable,
    migrationToFleetAvailable,
    indicesAvailable
  });
  return /*#__PURE__*/_react.default.createElement(_apm_main_template.ApmMainTemplate, {
    environmentFilter: false,
    pageHeader: {
      tabs,
      pageTitle: _i18n.i18n.translate('xpack.apm.settings.title', {
        defaultMessage: 'Settings'
      })
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, children);
}
function getTabs({
  core,
  selectedTab,
  router,
  defaultEnvironment,
  agentConfigurationAvailable,
  migrationToFleetAvailable,
  indicesAvailable
}) {
  var _core$application$cap;
  const canReadMlJobs = !!((_core$application$cap = core.application.capabilities.ml) !== null && _core$application$cap !== void 0 && _core$application$cap.canGetJobs);
  const tabs = [{
    key: 'general-settings',
    label: _i18n.i18n.translate('xpack.apm.settings.generalSettings', {
      defaultMessage: 'General settings'
    }),
    href: router.link('/settings/general-settings')
  }, ...(agentConfigurationAvailable ? [{
    key: 'agent-configuration',
    label: _i18n.i18n.translate('xpack.apm.settings.agentConfig', {
      defaultMessage: 'Agent Configuration'
    }),
    href: router.link('/settings/agent-configuration')
  }] : []), {
    key: 'agent-explorer',
    label: _i18n.i18n.translate('xpack.apm.settings.agentExplorer', {
      defaultMessage: 'Agent Explorer'
    }),
    href: router.link('/settings/agent-explorer', {
      query: {
        environment: defaultEnvironment,
        kuery: '',
        agentLanguage: '',
        serviceName: ''
      }
    })
  }, {
    key: 'agent-keys',
    label: _i18n.i18n.translate('xpack.apm.settings.agentKeys', {
      defaultMessage: 'Agent Keys'
    }),
    href: router.link('/settings/agent-keys')
  }, {
    key: 'anomaly-detection',
    label: _i18n.i18n.translate('xpack.apm.settings.anomalyDetection', {
      defaultMessage: 'Anomaly detection'
    }),
    href: router.link('/settings/anomaly-detection'),
    hidden: !canReadMlJobs
  }, {
    key: 'custom-links',
    label: _i18n.i18n.translate('xpack.apm.settings.customizeApp', {
      defaultMessage: 'Custom Links'
    }),
    href: router.link('/settings/custom-links')
  }, ...(indicesAvailable ? [{
    key: 'apm-indices',
    label: _i18n.i18n.translate('xpack.apm.settings.indices', {
      defaultMessage: 'Indices'
    }),
    href: router.link('/settings/apm-indices')
  }] : []), ...(migrationToFleetAvailable ? [{
    key: 'schema',
    label: _i18n.i18n.translate('xpack.apm.settings.schema', {
      defaultMessage: 'Schema'
    }),
    href: router.link('/settings/schema')
  }] : [])];
  return tabs.filter(t => !t.hidden).map(({
    href,
    key,
    label,
    append
  }) => ({
    href,
    label,
    append,
    isSelected: key === selectedTab
  }));
}