"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddEnvironments = AddEnvironments;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _anomaly_detection = require("../../../../../common/anomaly_detection");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _create_jobs = require("./create_jobs");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _use_anomaly_detection_jobs_context = require("../../../../context/anomaly_detection_jobs/use_anomaly_detection_jobs_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/anomaly_detection/add_environments.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INITIAL_DATA = {
  environments: []
};
function AddEnvironments({
  currentEnvironments,
  onCreateJobSuccess,
  onCancel
}) {
  const {
    notifications,
    application
  } = (0, _use_apm_plugin_context.useApmPluginContext)().core;
  const {
    anomalyDetectionJobsRefetch
  } = (0, _use_anomaly_detection_jobs_context.useAnomalyDetectionJobsContext)();
  const canCreateJob = !!application.capabilities.ml.canCreateJob;
  const {
    toasts
  } = notifications;
  const {
    data = INITIAL_DATA,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => callApmApi(`GET /internal/apm/settings/anomaly-detection/environments`), [], {
    preservePreviousData: false
  });
  const environmentOptions = data.environments.map(env => ({
    label: (0, _environment_filter_values.getEnvironmentLabel)(env),
    value: env,
    disabled: currentEnvironments.includes(env)
  }));
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [selectedOptions, setSelected] = (0, _react.useState)([]);
  if (!canCreateJob) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "warning",
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _anomaly_detection.ML_ERRORS.MISSING_WRITE_PRIVILEGES),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 12
      }
    });
  }
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.addEnvironments.titleText', {
    defaultMessage: 'Select environments'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.addEnvironments.descriptionText', {
    defaultMessage: 'Select the service environments that you want to enable anomaly detection in. Anomalies will surface for all services and transaction types within the selected environments.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.addEnvironments.selectorLabel', {
      defaultMessage: 'Environments'
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isLoading: isLoading,
    placeholder: _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.addEnvironments.selectorPlaceholder', {
      defaultMessage: 'Select or add environments'
    }),
    options: environmentOptions,
    selectedOptions: selectedOptions,
    onChange: nextSelectedOptions => {
      setSelected(nextSelectedOptions);
    },
    onCreateOption: searchValue => {
      if (currentEnvironments.includes(searchValue)) {
        return;
      }
      const newOption = {
        label: searchValue,
        value: searchValue
      };
      setSelected([...selectedOptions, newOption]);
    },
    isClearable: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "apmAddEnvironmentsCancelButton",
    "aria-label": "Cancel",
    onClick: onCancel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.addEnvironments.cancelButtonText', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmAddEnvironmentsCreateJobsButton",
    isLoading: isSaving,
    isDisabled: isSaving || selectedOptions.length === 0,
    fill: true,
    onClick: async () => {
      setIsSaving(true);
      const selectedEnvironments = selectedOptions.map(({
        value
      }) => value);
      const success = await (0, _create_jobs.createJobs)({
        environments: selectedEnvironments,
        toasts
      });
      if (success) {
        anomalyDetectionJobsRefetch();
        onCreateJobSuccess();
      }
      setIsSaving(false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.settings.anomalyDetection.addEnvironments.createJobsButtonText', {
    defaultMessage: 'Create Jobs'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }));
}