"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DependencyContents = DependencyContents;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _stats_list = require("./stats_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_map/popover/dependency_contents.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INITIAL_STATE = {
  currentPeriod: undefined,
  previousPeriod: undefined
};
function DependencyContents({
  elementData,
  environment,
  start,
  end
}) {
  const nodeData = elementData;
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/service-map', '/services/{serviceName}/service-map', '/mobile-services/{serviceName}/service-map');
  const {
    offset,
    comparisonEnabled
  } = query;
  const apmRouter = (0, _use_apm_router.useApmRouter)();
  const dependencyName = nodeData.label;
  const {
    data = INITIAL_STATE,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (dependencyName) {
      return callApmApi('GET /internal/apm/service-map/dependency', {
        params: {
          query: {
            dependencyName,
            environment,
            start,
            end,
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
          }
        }
      });
    }
  }, [environment, dependencyName, start, end, offset, comparisonEnabled]);
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const detailsUrl = dependencyName ? apmRouter.link('/dependencies/overview', {
    query: {
      ...query,
      dependencyName
    }
  }) : undefined;
  const trackEvent = (0, _public.useUiTracker)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_stats_list.StatsList, {
    data: data,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "apmDependencyContentsDependencyDetailsButton",
    href: detailsUrl,
    fill: true,
    onClick: () => {
      trackEvent({
        app: 'apm',
        metricType: _analytics.METRIC_TYPE.CLICK,
        metric: 'service_map_to_dependency_detail'
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.serviceMap.dependencyDetailsButtonText', {
    defaultMessage: 'Dependency Details'
  }))));
}