"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDashboardFileName = void 0;
var _elasticAgentUtils = require("@kbn/elastic-agent-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// We use the language name in the filename so we want to have a valid filename
// Example swift/iOS -> swift_ios : lowercased and '/' is replaces by '_'
const standardizeLanguageName = languageName => languageName ? languageName.toLowerCase().replace('/', '_') : undefined;
const getDashboardFileName = ({
  agentName,
  telemetrySdkName,
  telemetrySdkLanguage
}) => {
  const dataFormat = (0, _elasticAgentUtils.getIngestionPath)(!!(telemetrySdkName !== null && telemetrySdkName !== void 0 ? telemetrySdkName : telemetrySdkLanguage));
  const {
    sdkName,
    language
  } = (0, _elasticAgentUtils.getSdkNameAndLanguage)(agentName);
  const sdkLanguage = standardizeLanguageName(language);
  if (!sdkName || !sdkLanguage) {
    return undefined;
  }
  return `${dataFormat}-${sdkName}-${sdkLanguage}`;
};
exports.getDashboardFileName = getDashboardFileName;