"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateFormattedExample = exports.FormattedTokens = exports.FormattedRegex = exports.FormattedPatternExamples = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/format_category.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// copies of the syntax colors used in EuiCode
const tokenStyleLight = (0, _react2.css)`
  color: #765b96;
`;
const wildcardStyleLight = (0, _react2.css)`
  color: #357160;
`;
const tokenStyleDark = (0, _react2.css)`
  color: #a68ac5;
`;
const wildcardStyleDark = (0, _react2.css)`
  color: #54b399;
`;
const useStyles = () => {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const isDarkTheme = colorMode === 'DARK';
  return (0, _react.useMemo)(() => isDarkTheme ? {
    tokenStyle: tokenStyleDark,
    wildcardStyle: wildcardStyleDark
  } : {
    tokenStyle: tokenStyleLight,
    wildcardStyle: wildcardStyleLight
  }, [isDarkTheme]);
};
const useCreateFormattedExample = () => {
  const {
    tokenStyle,
    wildcardStyle
  } = useStyles();
  const createFormattedExample = (0, _react.useCallback)((key, example) => {
    const keyTokens = key.split(' ');
    let tempExample = ` ${example} `;
    const positions = keyTokens.map(t => ({
      id: t,
      start: 0,
      end: 0
    }));
    let offset = 0;
    // match each token in order and record the start and end position
    for (let i = 0; i < keyTokens.length; i++) {
      const token = keyTokens[i];
      const tokenReg = new RegExp(`(\\W)(${token})(\\W)`);
      let j = 0;
      const result = tokenReg.exec(tempExample);
      if (!result) {
        continue;
      }
      j = result.index;
      const localEndOFToken = j + token.length + 1;
      positions[i].start = offset + j + 1;
      positions[i].end = offset + localEndOFToken;
      // slice the example string to remove the token and preceding text
      // to ensure we don't match future tokens in earlier text
      tempExample = tempExample.slice(localEndOFToken);
      offset += localEndOFToken;
    }
    tempExample = ` ${example} `;

    // build up the list ot elements by chopping up the example string
    // using the token positions found above
    const elements = [];
    let pos = 0;
    for (let i = 0; i < positions.length; i++) {
      const elementKey = `${key}-token-${i}`;
      elements.push(/*#__PURE__*/_react.default.createElement("span", {
        css: wildcardStyle,
        key: elementKey,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 11
        }
      }, tempExample.substring(pos, positions[i].start)));
      elements.push(/*#__PURE__*/_react.default.createElement("span", {
        css: tokenStyle,
        key: `${elementKey}-2`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 11
        }
      }, tempExample.substring(positions[i].start, positions[i].end)));
      pos = positions[i].end;
    }
    elements.push(/*#__PURE__*/_react.default.createElement("span", {
      css: wildcardStyle,
      key: key,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }, tempExample.substring(positions[positions.length - 1].end)));
    return elements;
  }, [tokenStyle, wildcardStyle]);
  return createFormattedExample;
};
exports.useCreateFormattedExample = useCreateFormattedExample;
const FormattedPatternExamples = ({
  category,
  count
}) => {
  const createFormattedExample = useCreateFormattedExample();
  const e = (0, _react.useMemo)(() => {
    const {
      key,
      examples
    } = category;
    const tempCount = count === undefined || count > examples.length ? examples.length : count;
    const formattedExamples = new Array(tempCount).fill(0).map((_, i) => createFormattedExample(key, examples[i]));
    return formattedExamples.map((example, i) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: `example-${i}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("code", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 9
      }
    }, example), i < formattedExamples.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 45
      }
    }) : null));
  }, [category, count, createFormattedExample]);
  return /*#__PURE__*/_react.default.createElement(WrapInText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 10
    }
  }, e);
};
exports.FormattedPatternExamples = FormattedPatternExamples;
const FormattedRegex = ({
  category
}) => {
  const {
    tokenStyle,
    wildcardStyle
  } = useStyles();
  const {
    regex
  } = category;
  const formattedRegex = (0, _react.useMemo)(() => {
    const regexTokens = regex.split(/(\.\*\?)|(\.\+\?)/).filter(d => d !== undefined);
    const elements = [];
    for (let i = 0; i < regexTokens.length; i++) {
      const token = regexTokens[i];
      const key = `regex-${i}`;
      if (token.match(/\.\*\?|\.\+\?/)) {
        elements.push(/*#__PURE__*/_react.default.createElement("span", {
          css: wildcardStyle,
          key: key,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 159,
            columnNumber: 11
          }
        }, token));
      } else {
        elements.push(/*#__PURE__*/_react.default.createElement("span", {
          css: tokenStyle,
          key: key,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 165,
            columnNumber: 11
          }
        }, token));
      }
    }
    return elements;
  }, [regex, tokenStyle, wildcardStyle]);
  return /*#__PURE__*/_react.default.createElement(WrapInText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("code", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, formattedRegex));
};
exports.FormattedRegex = FormattedRegex;
const FormattedTokens = ({
  category
}) => {
  const {
    tokenStyle
  } = useStyles();
  return /*#__PURE__*/_react.default.createElement(WrapInText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("code", {
    css: tokenStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, category.key));
};
exports.FormattedTokens = FormattedTokens;
const WrapInText = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  css: {
    fontWeight: 'bold'
  },
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 191,
    columnNumber: 3
  }
}, children);