"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertStreamlangDSLActionsToIngestPipelineProcessors = convertStreamlangDSLActionsToIngestPipelineProcessors;
var _condition_to_painless = require("../../conditions/condition_to_painless");
var _pre_processing = require("./processors/pre_processing");
var _manual_pipeline_processor = require("./processors/manual_pipeline_processor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function convertStreamlangDSLActionsToIngestPipelineProcessors(actionSteps, transpilationOptions) {
  return actionSteps.flatMap(actionStep => {
    const renames = _pre_processing.processorFieldRenames[actionStep.action] || {};
    const {
      action,
      ...rest
    } = actionStep;

    // Rename Streamlang to Ingest Processor specific fields
    const processorWithRenames = (0, _pre_processing.renameFields)(rest, renames);
    if ('customIdentifier' in processorWithRenames) {
      if (transpilationOptions !== null && transpilationOptions !== void 0 && transpilationOptions.traceCustomIdentifiers) {
        // If tracing custom identifiers, we can keep it as is
        processorWithRenames.tag = processorWithRenames.customIdentifier;
        delete processorWithRenames.customIdentifier;
      } else {
        // Otherwise, we remove it to avoid passing it to Elasticsearch
        delete processorWithRenames.customIdentifier;
      }
    }
    const processorWithCompiledConditions = 'if' in processorWithRenames && processorWithRenames.if ? {
      ...processorWithRenames,
      if: (0, _condition_to_painless.conditionToPainless)(processorWithRenames.if)
    } : processorWithRenames;
    if (action === 'manual_ingest_pipeline') {
      return (0, _manual_pipeline_processor.processManualIngestPipelineProcessors)(processorWithCompiledConditions, transpilationOptions);
    }
    return (0, _pre_processing.applyPreProcessing)(action, processorWithCompiledConditions);
  });
}