"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrowdstrikeError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseStatusMessage = message => {
  const regex = /Status code: (\d+). Message: (.+)/;
  const match = message.match(regex);
  if (match) {
    return {
      code: parseInt(match[1], 10),
      message: match[2]
    };
  }
  return {
    code: 500,
    message
  };
};
class CrowdstrikeError extends Error {
  constructor(message) {
    super(message);
    (0, _defineProperty2.default)(this, "code", void 0);
    (0, _defineProperty2.default)(this, "message", void 0);
    const parsedMessage = parseStatusMessage(message);
    this.code = parsedMessage === null || parsedMessage === void 0 ? void 0 : parsedMessage.code;
    this.message = (parsedMessage === null || parsedMessage === void 0 ? void 0 : parsedMessage.message) || 'Unknown Crowdstrike error';
  }
}
exports.CrowdstrikeError = CrowdstrikeError;