"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/webhook/webhook_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WebhookParamsFields = ({
  actionParams,
  editAction,
  index,
  messageVariables,
  errors
}) => {
  const {
    body
  } = actionParams;
  return /*#__PURE__*/_react.default.createElement(_public.JsonEditorWithMessageVariables, {
    messageVariables: messageVariables,
    paramsProperty: 'body',
    inputTargetValue: body,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.webhook.bodyFieldLabel', {
      defaultMessage: 'Body'
    }),
    ariaLabel: _i18n.i18n.translate('xpack.stackConnectors.components.webhook.bodyCodeEditorAriaLabel', {
      defaultMessage: 'Code editor'
    }),
    errors: errors.body,
    onDocumentsChange: json => {
      editAction('body', json, index);
    },
    onBlur: () => {
      if (!body) {
        editAction('body', '', index);
      }
    },
    dataTestSubj: "actionJsonEditor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = WebhookParamsFields;
module.exports = exports.default;