"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.simpleConnectorQueryClient = exports.default = exports.SlackActionFieldsComponents = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _lodash = require("lodash");
var _reactQuery = require("@kbn/react-query");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_valid_channels = require("./use_valid_channels");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/slack_api/slack_connectors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/** wait this many ms after the user completes typing before applying the filter input */
const INPUT_TIMEOUT = 250;
const getSecretsFormSchema = docLinks => [{
  id: 'token',
  label: i18n.TOKEN_LABEL,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.alerting.slackApiAction,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.stackConnectors.components.slack_api.apiKeyDocumentation",
    defaultMessage: "Create a Slack Web API token",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }))
}];
const getConfigFormSchemaAfterSecrets = ({
  options,
  isLoading,
  isDisabled,
  onChange,
  onCreateOption,
  selectedOptions
}) => [{
  id: 'allowedChannels',
  isRequired: true,
  label: i18n.ALLOWED_CHANNELS,
  type: 'COMBO_BOX',
  euiFieldProps: {
    noSuggestions: true,
    isDisabled,
    isLoading,
    options,
    onChange,
    onCreateOption,
    selectedOptions
  }
}];
const NO_SCHEMA = [];
const SEPARATOR = ' - ';
const SlackActionFieldsComponents = ({
  readOnly,
  isEdit
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  const form = (0, _hook_form_lib.useFormContext)();
  const {
    setFieldValue
  } = form;
  const [formData] = (0, _hook_form_lib.useFormData)({
    form
  });
  const [authToken, setAuthToken] = (0, _react.useState)('');
  const [channelsToValidate, setChannelsToValidate] = (0, _react.useState)('');
  const {
    channels: validChannels,
    isLoading,
    resetChannelsToValidate
  } = (0, _use_valid_channels.useValidChannels)({
    authToken,
    channelId: channelsToValidate
  });
  const onCreateOption = (0, _react.useCallback)((searchValue, options) => {
    setChannelsToValidate(searchValue);
  }, []);
  const onChange = (0, _react.useCallback)(options => {
    const tempChannelIds = options.map(opt => {
      return opt.value;
    });
    setChannelsToValidate('');
    resetChannelsToValidate(tempChannelIds);
  }, [resetChannelsToValidate]);
  const configFormSchemaAfterSecrets = (0, _react.useMemo)(() => {
    const validChannelsFormatted = validChannels.map(channel => ({
      label: `${channel.id}${SEPARATOR}${channel.name}`,
      value: channel
    }));
    return getConfigFormSchemaAfterSecrets({
      options: validChannelsFormatted,
      isLoading,
      isDisabled: (authToken || '').length === 0,
      onChange,
      onCreateOption,
      selectedOptions: validChannelsFormatted
    });
  }, [validChannels, isLoading, authToken, onChange, onCreateOption]);
  const debounceSetToken = (0, _lodash.debounce)(setAuthToken, INPUT_TIMEOUT);
  (0, _react.useEffect)(() => {
    if (formData.secrets && formData.secrets.token !== authToken) {
      debounceSetToken(formData.secrets.token);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [formData.secrets]);
  (0, _react.useEffect)(() => {
    if ((0, _lodash.isEmpty)(authToken) && validChannels.length > 0) {
      setFieldValue('config.allowedChannels', []);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [authToken]);
  (0, _react.useEffect)(() => {
    var _formData$config;
    const configAllowedChannels = (formData === null || formData === void 0 ? void 0 : (_formData$config = formData.config) === null || _formData$config === void 0 ? void 0 : _formData$config.allowedChannels) || [];
    if (!(0, _lodash.isEqual)(configAllowedChannels, validChannels)) {
      setFieldValue('config.allowedChannels', validChannels);
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [validChannels]);
  const isInitialyzed = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    var _formData$config2;
    const configAllowedChannels = (formData === null || formData === void 0 ? void 0 : (_formData$config2 = formData.config) === null || _formData$config2 === void 0 ? void 0 : _formData$config2.allowedChannels) || [];
    if (!isInitialyzed.current && configAllowedChannels.length > 0 && !(0, _lodash.isEqual)(configAllowedChannels, validChannels)) {
      isInitialyzed.current = true;
      resetChannelsToValidate(formData.config.allowedChannels);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [formData.config]);
  return /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: NO_SCHEMA,
    secretsFormSchema: getSecretsFormSchema(docLinks),
    configFormSchemaAfterSecrets: configFormSchemaAfterSecrets,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 5
    }
  });
};
exports.SlackActionFieldsComponents = SlackActionFieldsComponents;
const simpleConnectorQueryClient = exports.simpleConnectorQueryClient = new _reactQuery.QueryClient();
const SlackActionFields = props => /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
  client: simpleConnectorQueryClient,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 187,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(SlackActionFieldsComponents, (0, _extends2.default)({}, props, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 188,
    columnNumber: 5
  }
})));

// eslint-disable-next-line import/no-default-export
exports.default = SlackActionFields;