"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.geminiSecrets = exports.geminiConfig = exports.DEFAULT_BODY = void 0;
var _react = _interopRequireDefault(require("react"));
var _inferenceEndpointUiCommon = require("@kbn/inference-endpoint-ui-common");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/gemini/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _genai_connectors = require("../../common/genai_connectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762971603108095020/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/stack_connectors/public/connector_types/gemini/constants.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const generationConfig = {
  temperature: 0,
  maxOutputTokens: _constants.DEFAULT_TOKEN_LIMIT
};
const contents = [{
  role: 'user',
  parts: [{
    text: 'Hello world!'
  }]
}];
const DEFAULT_BODY = exports.DEFAULT_BODY = JSON.stringify({
  contents,
  generation_config: generationConfig
});
const geminiConfig = exports.geminiConfig = [{
  id: 'apiUrl',
  label: i18n.API_URL_LABEL,
  isUrlField: true,
  defaultValue: _constants.DEFAULT_GEMINI_URL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Google Gemini API endpoint URL. For more information on the URL, refer to the {geminiAPIUrlDocs}.",
    id: "xpack.stackConnectors.components.gemini.geminiAPIDocumentation",
    values: {
      geminiAPIUrlDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "gemini-api-doc",
        href: "https://cloud.google.com/vertex-ai/generative-ai/docs/start/quickstarts/quickstart-multimodal#gemini-setup-environment-drest",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 13
        }
      }, `${i18n.gemini} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  })
}, {
  id: 'gcpRegion',
  label: i18n.GCP_REGION,
  isUrlField: false,
  defaultValue: _constants.DEFAULT_GCP_REGION,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Please provide the GCP region where the Vertex AI API(s) is enabled. For more information, refer to the {geminiVertexAIDocs}.",
    id: "xpack.stackConnectors.components.gemini.geminiRegionDocumentation",
    values: {
      geminiVertexAIDocs: _inferenceEndpointUiCommon.GEMINI_REGION_DOC_LINK
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  })
}, {
  id: 'gcpProjectID',
  label: i18n.GCP_PROJECT_ID,
  isUrlField: false,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The GCP Project ID which has Vertex AI API(s) enabled. For more information on the URL, refer to the {geminiVertexAIDocs}.",
    id: "xpack.stackConnectors.components.gemini.geminiProjectDocumentation",
    values: {
      geminiVertexAIDocs: _inferenceEndpointUiCommon.GEMINI_PROJECT_ID_DOC_LINK
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  })
}, {
  id: 'defaultModel',
  label: i18n.DEFAULT_MODEL_LABEL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Current support is for the Gemini models. For more information, refer to the {geminiAPIModelDocs}.",
    id: "xpack.stackConnectors.components.gemini.geminiModelDocumentation",
    values: {
      geminiAPIModelDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "gemini-api-model-doc",
        href: "https://cloud.google.com/vertex-ai/generative-ai/docs/learn/models/",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 13
        }
      }, `${i18n.gemini} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }),
  defaultValue: _constants.DEFAULT_GEMINI_MODEL
}, _genai_connectors.contextWindowLengthField];
const geminiSecrets = exports.geminiSecrets = [{
  id: 'credentialsJson',
  label: i18n.CREDENTIALS_JSON,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "To authenticate to Gemini API please provide your GCP Service Account credentials JSON data. For more information, refer to the {geminiAuthDocs}.",
    id: "xpack.stackConnectors.components.gemini.geminiSecretDocumentation",
    values: {
      geminiAuthDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "aws-api-keys-doc",
        href: "https://cloud.google.com/iam/docs/keys-list-get",
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 13
        }
      }, `${i18n.gemini} ${i18n.DOCUMENTATION}`)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  })
}];